/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.mixin.config;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import malte0811.ferritecore.mixin.config.FerriteConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public abstract class FerriteMixinConfig
implements IMixinConfigPlugin {
    protected static final Logger LOGGER;
    protected static final boolean HAS_HYDROGEN;
    private String prefix = null;
    @Nullable
    private final FerriteConfig.Option enableOption;
    private final boolean disableWithHydrogen;

    protected FerriteMixinConfig(@Nullable FerriteConfig.Option enableOption, boolean disableWithHydrogen) {
        this.enableOption = enableOption;
        this.disableWithHydrogen = disableWithHydrogen;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Preconditions.checkState((boolean)mixinClassName.startsWith(this.prefix), (Object)("Unexpected prefix on " + mixinClassName));
        if (this.enableOption != null && !this.enableOption.isEnabled()) {
            LOGGER.warn("Mixin " + mixinClassName + " is disabled by config");
            return false;
        }
        if (HAS_HYDROGEN && this.disableWithHydrogen) {
            LOGGER.warn("Mixin " + mixinClassName + " is disabled as Hydrogen is installed");
            return false;
        }
        return true;
    }

    public void onLoad(String mixinPackage) {
        this.prefix = mixinPackage + ".";
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        boolean hasHydrogen;
        LOGGER = LogManager.getLogger((String)"ferritecore-mixin");
        try {
            MixinService.getService().getBytecodeProvider().getClassNode("me.jellysquid.mods.hydrogen.common.HydrogenMod");
            hasHydrogen = true;
        }
        catch (IOException | ClassNotFoundException e) {
            hasHydrogen = false;
        }
        HAS_HYDROGEN = hasHydrogen;
    }
}

