/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.structure;

import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.gen.feature.template.Template;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.util.FileUtil;

public class CachingStructureManager {
    private static ThreadLocal<MessageDigest> digestThreadLocal = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    });
    private static final File STRUCTURE_CACHE_FOLDER = FileUtil.childFile(ModernFixPlatformHooks.INSTANCE.getGameDirectory().resolve("modernfix").resolve("structureCacheV1").toFile());
    private static final Set<String> laggyStructureMods;
    private static final int MAX_HASH_LENGTH = 9;

    public static Template readStructure(ResourceLocation location, DataFixer datafixer, InputStream stream) throws IOException {
        CompoundNBT tag = CachingStructureManager.readStructureTag(location, datafixer, stream);
        Template template = new Template();
        template.func_186256_b(tag);
        return template;
    }

    private static String encodeHex(byte[] byteArray) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static String truncateHash(String hash) {
        return hash.substring(0, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundNBT readStructureTag(ResourceLocation location, DataFixer datafixer, InputStream stream) throws IOException {
        int requiredMinimumDataVersion;
        int currentDataVersion;
        byte[] structureBytes = CachingStructureManager.toBytes(stream);
        CompoundNBT currentTag = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(structureBytes));
        if (!currentTag.func_150297_b("DataVersion", 99)) {
            currentTag.func_74768_a("DataVersion", 500);
        }
        if ((currentDataVersion = currentTag.func_74762_e("DataVersion")) < (requiredMinimumDataVersion = SharedConstants.func_215069_a().getWorldVersion())) {
            MessageDigest hasher = digestThreadLocal.get();
            hasher.reset();
            String hash = CachingStructureManager.encodeHex(hasher.digest(structureBytes));
            CompoundNBT cachedUpgraded = CachingStructureManager.getCachedUpgraded(location, CachingStructureManager.truncateHash(hash));
            if (cachedUpgraded == null) {
                cachedUpgraded = CachingStructureManager.getCachedUpgraded(location, hash);
            }
            if (cachedUpgraded != null && cachedUpgraded.func_74762_e("DataVersion") == requiredMinimumDataVersion) {
                ModernFix.LOGGER.debug("Using cached upgraded version of {}", (Object)location);
                currentTag = cachedUpgraded;
            } else {
                Set<String> set = laggyStructureMods;
                synchronized (set) {
                    if (laggyStructureMods.add(location.func_110624_b())) {
                        ModernFix.LOGGER.warn("The namespace {} contains an outdated structure file, which can cause worldgen lag. Please view debug.log for the full filename, determine which mod provides the structure, and report to the mod/datapack author, including the debug log.", (Object)location.func_110624_b());
                    }
                }
                ModernFix.LOGGER.debug("Structure {} is being run through DFU (hash {}), this will cause launch time delays", (Object)location, (Object)hash);
                currentTag = NBTUtil.func_210821_a((DataFixer)datafixer, (DefaultTypeReferences)DefaultTypeReferences.STRUCTURE, (CompoundNBT)currentTag, (int)currentDataVersion, (int)SharedConstants.func_215069_a().getWorldVersion());
                currentTag.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
                CachingStructureManager.saveCachedUpgraded(location, hash, currentTag);
            }
        }
        return currentTag;
    }

    private static File getCachePath(ResourceLocation location, String hash) {
        String fileName = location.func_110624_b() + "_" + location.func_110623_a().replace('/', '_') + "_" + hash + ".nbt";
        return new File(STRUCTURE_CACHE_FOLDER, fileName);
    }

    private static synchronized CompoundNBT getCachedUpgraded(ResourceLocation location, String hash) {
        File theFile = CachingStructureManager.getCachePath(location, hash);
        try {
            return CompressedStreamTools.func_244263_a((File)theFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static synchronized void saveCachedUpgraded(ResourceLocation location, String hash, CompoundNBT tagToSave) {
        File theFile = CachingStructureManager.getCachePath(location, CachingStructureManager.truncateHash(hash));
        try {
            CompressedStreamTools.func_244264_a((CompoundNBT)tagToSave, (File)theFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] toBytes(InputStream stream) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] tmp = new byte[16384];
        while ((n = stream.read(tmp, 0, tmp.length)) != -1) {
            buffer.write(tmp, 0, n);
        }
        return buffer.toByteArray();
    }

    static {
        STRUCTURE_CACHE_FOLDER.mkdirs();
        laggyStructureMods = new ObjectOpenHashSet();
    }
}

