/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.structure.logic;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.fml.loading.Java9BackportUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.forge.structure.AsyncLocator;
import org.embeddedt.modernfix.forge.structure.logic.CommonLogic;

public class ExplorationMapFunctionLogic {
    private static final Cache<ItemStack, ITextComponent> MAP_NAME_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final int MAX_STACK_SIZE = 64;

    private ExplorationMapFunctionLogic() {
    }

    public static void cacheName(ItemStack stack, ITextComponent name) {
        MAP_NAME_CACHE.put((Object)stack, (Object)name);
    }

    public static ITextComponent getCachedName(ItemStack stack) {
        ITextComponent name = (ITextComponent)MAP_NAME_CACHE.getIfPresent((Object)stack);
        MAP_NAME_CACHE.invalidate((Object)stack);
        return name;
    }

    public static void invalidateMap(ItemStack mapStack, ServerWorld level, BlockPos pos) {
        ExplorationMapFunctionLogic.handleUpdateMapInChest(mapStack, level, pos, (handler, slot) -> {
            if (handler instanceof IItemHandlerModifiable) {
                ((IItemHandlerModifiable)handler).setStackInSlot(slot.intValue(), new ItemStack((IItemProvider)Items.field_151148_bJ));
            } else {
                handler.extractItem(slot.intValue(), 64, false);
                handler.insertItem(slot.intValue(), new ItemStack((IItemProvider)Items.field_151148_bJ), false);
            }
        });
    }

    public static void updateMap(ItemStack mapStack, ServerWorld level, BlockPos pos, int scale, MapDecoration.Type destinationType, BlockPos invPos, ITextComponent displayName) {
        CommonLogic.updateMap(mapStack, level, pos, scale, destinationType, displayName);
        ExplorationMapFunctionLogic.handleUpdateMapInChest(mapStack, level, invPos, (handler, slot) -> {});
    }

    public static void handleUpdateMapInChest(ItemStack mapStack, ServerWorld level, BlockPos invPos, BiConsumer<IItemHandler, Integer> handleSlotFound) {
        TileEntity be = level.func_175625_s(invPos);
        if (be != null) {
            Java9BackportUtils.ifPresentOrElse((Optional)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve(), itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack slotStack = itemHandler.getStackInSlot(i);
                    if (slotStack != mapStack) continue;
                    handleSlotFound.accept((IItemHandler)itemHandler, i);
                    CommonLogic.broadcastChestChanges(level, be);
                    return;
                }
            }, () -> ModernFix.LOGGER.warn("Couldn't find item handler capability on chest {} at {}", (Object)be.getClass().getSimpleName(), (Object)invPos));
        } else {
            ModernFix.LOGGER.warn("Couldn't find block entity on chest {} at {}", (Object)level.func_180495_p(invPos), (Object)invPos);
        }
    }

    public static void handleLocationFound(ItemStack mapStack, ServerWorld level, BlockPos pos, int scale, MapDecoration.Type destinationType, Structure<?> destination, BlockPos invPos) {
        if (pos == null) {
            ExplorationMapFunctionLogic.invalidateMap(mapStack, level, invPos);
        } else {
            ITextComponent displayName = ExplorationMapFunctionLogic.getCachedName(mapStack);
            if (displayName == null) {
                displayName = new TranslationTextComponent("filled_map." + destination.func_143025_a().toLowerCase(Locale.ROOT));
            }
            ExplorationMapFunctionLogic.updateMap(mapStack, level, pos, scale, destinationType, invPos, displayName);
        }
    }

    public static ItemStack updateMapAsync(ServerWorld level, BlockPos blockPos, int scale, int searchRadius, boolean skipKnownStructures, MapDecoration.Type destinationType, Structure<?> destination) {
        ItemStack mapStack = CommonLogic.createEmptyMap();
        AsyncLocator.locateLevel(level, ImmutableSet.of(destination), blockPos, searchRadius, skipKnownStructures).thenOnServerThread(pos -> ExplorationMapFunctionLogic.handleLocationFound(mapStack, level, pos, scale, destinationType, destination, blockPos));
        return mapStack;
    }
}

