/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.async_locator;

import com.google.common.collect.ImmutableSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.forge.structure.AsyncLocator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(targets={"net.minecraft.world.entity.animal.Dolphin$DolphinSwimToTreasureGoal"})
public class DolphinSwimToTreasureGoalMixin {
    @Final
    @Shadow
    private DolphinEntity field_208057_a;
    @Shadow
    private boolean field_208058_b;
    private AsyncLocator.LocateTask<BlockPos> locateTask = null;

    @Inject(method={"start"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;findNearestMapFeature(Lnet/minecraft/world/level/levelgen/feature/StructureFeature;Lnet/minecraft/core/BlockPos;IZ)Lnet/minecraft/core/BlockPos;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void findTreasureAsync(CallbackInfo ci, ServerWorld level, BlockPos blockpos) {
        ModernFix.LOGGER.debug("Intercepted DolphinSwimToTreasureGoal#start call");
        this.handleFindTreasureAsync(level, blockpos);
        ci.cancel();
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void continueToUseIfLocatingTreasure(CallbackInfoReturnable<Boolean> cir) {
        if (this.locateTask != null) {
            ModernFix.LOGGER.debug("Locating task ongoing - returning true for continueToUse()");
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    public void stopLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ModernFix.LOGGER.debug("Locating task ongoing - cancelling during stop()");
            this.locateTask.cancel();
            this.locateTask = null;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void skipTickingIfLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ModernFix.LOGGER.debug("Locating task ongoing - skipping tick()");
            ci.cancel();
        }
    }

    private void handleFindTreasureAsync(ServerWorld level, BlockPos blockPos) {
        this.locateTask = AsyncLocator.locateLevel(level, ImmutableSet.of((Object)Structure.field_236377_m_, (Object)Structure.field_236373_i_), blockPos, 50, false).thenOnServerThread(pos -> this.handleLocationFound(level, (BlockPos)pos));
    }

    private void handleLocationFound(ServerWorld level, BlockPos pos) {
        this.locateTask = null;
        if (pos != null) {
            ModernFix.LOGGER.debug("Location found - updating dolphin treasure pos");
            this.field_208057_a.func_208012_g(pos);
            level.func_72960_a((Entity)this.field_208057_a, (byte)38);
        } else {
            ModernFix.LOGGER.debug("No location found - marking dolphin as stuck");
            this.field_208058_b = true;
        }
    }
}

