/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.util;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.MapPolygonWithHoles;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class PolygonHelper {
    public static MapPolygon createChunkPolygonForWorldCoords(int x, int y, int z) {
        return PolygonHelper.createChunkPolygon(x >> 4, y, z >> 4);
    }

    public static MapPolygon createChunkPolygon(int chunkX, int y, int chunkZ) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        BlockPos sw = new BlockPos(x, y, z + 16);
        BlockPos se = new BlockPos(x + 16, y, z + 16);
        BlockPos ne = new BlockPos(x + 16, y, z);
        BlockPos nw = new BlockPos(x, y, z);
        return new MapPolygon(sw, se, ne, nw);
    }

    public static MapPolygon createBlockRect(BlockPos corner1, BlockPos corner2) {
        int minX = Math.min(corner1.func_177958_n(), corner2.func_177958_n());
        int maxX = Math.max(corner1.func_177958_n(), corner2.func_177958_n());
        int minZ = Math.min(corner1.func_177952_p(), corner2.func_177952_p());
        int maxZ = Math.max(corner1.func_177952_p(), corner2.func_177952_p());
        BlockPos sw = new BlockPos(minX, corner1.func_177956_o(), maxZ);
        BlockPos se = new BlockPos(maxX, corner1.func_177956_o(), maxZ);
        BlockPos ne = new BlockPos(maxX, corner2.func_177956_o(), minZ);
        BlockPos nw = new BlockPos(minX, corner2.func_177956_o(), minZ);
        return new MapPolygon(sw, se, ne, nw);
    }

    @Nonnull
    public static Area createChunksArea(@Nonnull Collection<ChunkPos> chunks) {
        Area area = new Area();
        for (ChunkPos chunkPos : chunks) {
            area.add(new Area(new Rectangle(chunkPos.func_180334_c(), chunkPos.func_180333_d(), 16, 16)));
        }
        return area;
    }

    @Nonnull
    public static List<MapPolygonWithHoles> createChunksPolygon(@Nonnull Collection<ChunkPos> chunks, int y) {
        return PolygonHelper.createPolygonFromArea(PolygonHelper.createChunksArea(chunks), y);
    }

    @Nonnull
    public static Area toArea(@Nonnull MapPolygon polygon) {
        List<BlockPos> points = polygon.getPoints();
        int[] xPoints = new int[points.size()];
        int[] yPoints = new int[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            xPoints[i] = points.get(i).func_177958_n();
            yPoints[i] = points.get(i).func_177952_p();
        }
        return new Area(new Polygon(xPoints, yPoints, points.size()));
    }

    @Nonnull
    public static List<MapPolygonWithHoles> createPolygonFromArea(@Nonnull Area area, int y) {
        ArrayList<MapPolygon> polygons = new ArrayList<MapPolygon>();
        List<Object> poly = new ArrayList<BlockPos>();
        PathIterator iterator2 = area.getPathIterator(null);
        float[] points = new float[6];
        while (!iterator2.isDone()) {
            int type = iterator2.currentSegment(points);
            switch (type) {
                case 0: {
                    if (!poly.isEmpty()) {
                        poly = PolygonHelper.simplify(poly);
                        polygons.add(new MapPolygon(poly));
                        poly = new ArrayList();
                    }
                    poly.add(new BlockPos(Math.round(points[0]), y, Math.round(points[1])));
                    break;
                }
                case 1: {
                    poly.add(new BlockPos(Math.round(points[0]), y, Math.round(points[1])));
                }
            }
            iterator2.next();
        }
        if (!poly.isEmpty()) {
            polygons.add(new MapPolygon(poly));
        }
        return PolygonHelper.classifyAndGroup(polygons);
    }

    @Nonnull
    public static List<MapPolygonWithHoles> classifyAndGroup(@Nonnull List<MapPolygon> polygons) {
        ArrayList<MapPolygon> hulls = new ArrayList<MapPolygon>();
        ArrayList<MapPolygon> holes = new ArrayList<MapPolygon>();
        for (MapPolygon polygon : polygons) {
            if (PolygonHelper.isHole(polygon)) {
                holes.add(polygon);
                continue;
            }
            hulls.add(polygon);
        }
        List holeAreas = holes.stream().map(hole -> new Tuple(hole, (Object)PolygonHelper.toArea(hole))).collect(Collectors.toList());
        ArrayList<MapPolygonWithHoles> result = new ArrayList<MapPolygonWithHoles>();
        for (MapPolygon hull : hulls) {
            Area hullArea = PolygonHelper.toArea(hull);
            ArrayList<MapPolygon> hullHoles = new ArrayList<MapPolygon>();
            Iterator iterator2 = holeAreas.iterator();
            while (iterator2.hasNext()) {
                Tuple holeArea = (Tuple)iterator2.next();
                Area intersection = new Area(hullArea);
                intersection.intersect((Area)holeArea.func_76340_b());
                if (intersection.isEmpty()) continue;
                hullHoles.add((MapPolygon)holeArea.func_76341_a());
                iterator2.remove();
            }
            result.add(new MapPolygonWithHoles(hull, hullHoles));
        }
        return result;
    }

    @Nonnull
    private static List<BlockPos> simplify(@Nonnull List<BlockPos> points) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        BlockPos prev2 = points.get(0);
        BlockPos prev1 = points.get(1);
        result.add(prev2);
        for (int index = 2; index < points.size(); ++index) {
            BlockPos next = points.get(index);
            if (prev2.func_177958_n() == prev1.func_177958_n() && prev1.func_177958_n() == next.func_177958_n()) {
                prev1 = next;
                continue;
            }
            if (prev2.func_177952_p() == prev1.func_177952_p() && prev1.func_177952_p() == next.func_177952_p()) {
                prev1 = next;
                continue;
            }
            result.add(prev1);
            prev2 = prev1;
            prev1 = next;
        }
        result.add(prev1);
        return result;
    }

    private static boolean isHole(@Nonnull MapPolygon polygon) {
        long sum = 0L;
        List<BlockPos> points = polygon.getPoints();
        BlockPos a = points.get(points.size() - 1);
        for (BlockPos b : points) {
            sum += (long)(b.func_177958_n() - a.func_177958_n()) * (long)(b.func_177952_p() + a.func_177952_p());
            a = b;
        }
        return sum < 0L;
    }
}

