/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.sync;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncThemeDecksPacket
extends AbstractTCGPacket {
    private List<ThemeDeck> themeDecks;

    public SyncThemeDecksPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SyncThemeDecksPacket(List<ThemeDeck> themeDecks) {
        this();
        this.themeDecks = themeDecks;
    }

    public static void sync(ServerPlayerEntity player) {
        List<ThemeDeck> themeDecks = ThemeDecks.getAll();
        int groups = Math.max(1, themeDecks.size() / 10);
        int size = themeDecks.size() / groups;
        for (int group = 0; group < groups; ++group) {
            int i;
            ArrayList sublist = Lists.newArrayList();
            if (group + 1 == groups) {
                for (i = size * group; i < themeDecks.size(); ++i) {
                    sublist.add(themeDecks.get(i));
                }
            } else {
                for (i = size * group; i < size * (group + 1); ++i) {
                    sublist.add(themeDecks.get(i));
                }
            }
            NetworkHelper.sendPacket(player, new SyncThemeDecksPacket(sublist));
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.themeDecks = Lists.newArrayList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String json = buffer.func_218666_n() + buffer.func_218666_n();
            this.themeDecks.add((ThemeDeck)ThemeDecks.GSON.fromJson(json, ThemeDeck.class));
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.themeDecks.size());
        for (ThemeDeck themeDeck : this.themeDecks) {
            int length = themeDeck.getJson().length() / 2;
            String firstHalf = themeDeck.getJson().substring(0, length);
            String secondHalf = themeDeck.getJson().substring(length);
            buffer.func_180714_a(firstHalf);
            buffer.func_180714_a(secondHalf);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        RegistryManager.invalidateRegistry(ThemeDeck.class);
        for (ThemeDeck themeDeck : this.themeDecks) {
            ThemeDecks.register(themeDeck);
        }
    }
}

