/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.ArrayList;
import java.util.List;

public class Buzzap
extends BasePowerEffect {
    public Buzzap() {
        super("Buzzap");
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        switch (pokemon.getParameters().size()) {
            case 0: {
                CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "power.buzzap.selector.chooseenergy");
                for (ImmutableCard energyCard : Cards.getEnergyCards()) {
                    selector.getCardList().add(new CardWithLocation(new CommonCardState(energyCard), false, null, 0));
                }
                return selector;
            }
            case 1: {
                CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "power.buzzap.selector.chooseattach");
                PlayerServerState player = server.getPlayer(server.getCurrentTurn());
                if (player.getActiveCard() != null && player.getActiveCard() != pokemon) {
                    selector.getCardList().add(new CardWithLocation(player.getActiveCard(), true, BoardLocation.Active, 0));
                }
                for (int i = 0; i < player.getBenchCards().length; ++i) {
                    if (player.getBenchCards()[i] == null || player.getBenchCards()[i] == pokemon) continue;
                    selector.getCardList().add(new CardWithLocation(player.getBenchCards()[i], true, BoardLocation.Bench, i));
                }
                return selector;
            }
        }
        return null;
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState client) {
        return pokemon.getParameters().size() == 2;
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        PokemonCardState attachTo = (PokemonCardState)pokemon.getParameters().get(1);
        pokemon.getStatus().setDamage(pokemon.getHP());
        pokemon.getParameters().remove(1);
        attachTo.getAttachments().add(pokemon);
    }

    @Override
    public List<CommonCardState> getEnergyEquivalence(CommonCardState attachment) {
        if (attachment.getParameters().size() == 0) {
            return null;
        }
        ArrayList<CommonCardState> result = new ArrayList<CommonCardState>();
        for (int i = 0; i < 2; ++i) {
            result.add(attachment.getParameters().get(0));
        }
        return result;
    }

    @Override
    public void cleanUp(PokemonCardState pokemon, GameServerState server) {
    }

    @Override
    public boolean holdParameters() {
        return true;
    }
}

