/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.extras;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.enums.ServerCosmetics;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.Tuple;

public class PixelExtrasData {
    public final UUID id;
    Tuple<EnumSet<ExtrasContact.Groups>, int[]> apiData;
    EnumSet<ServerCosmetics> serverCosmetics = null;
    private final EnumSet<Category> enabled = EnumSet.allOf(Category.class);
    private HatType hatType = HatType.NONE;
    private MonocleType monocleType = MonocleType.NONE;
    private WingType wingType = WingType.NONE;
    SashType sashType = null;
    RobeType robeType = RobeType.NONE;
    SphealType sphealType = null;
    private int[] sashColors = null;
    private int[] capColors = new int[]{Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue()};
    private int[] monocleOffset = new int[]{5, 4, 3};

    public PixelExtrasData(UUID id) {
        this.id = id;
    }

    public boolean isReady() {
        return this.apiData != null;
    }

    public boolean hasData() {
        return this.has(ExtrasContact.Groups.values()) || this.has(ServerCosmetics.values());
    }

    public void updateServerCosmetics(Set<ServerCosmetics> serverCosmetics) {
        this.serverCosmetics = serverCosmetics.isEmpty() ? EnumSet.noneOf(ServerCosmetics.class) : EnumSet.copyOf(serverCosmetics);
        this.getHatType();
        this.getMonocleType();
        this.getRobeType();
        this.getSashType();
        this.getSphealType();
    }

    public Set<ServerCosmetics> getServerCosmetics() {
        return this.serverCosmetics != null ? this.serverCosmetics : Collections.emptySet();
    }

    public int dataHash() {
        int hash = 0;
        if (!this.isReady()) {
            return hash;
        }
        for (ExtrasContact.Groups group : (EnumSet)this.apiData.func_76341_a()) {
            if (group == null) continue;
            hash = 31 * hash + (group.ordinal() + 1);
        }
        return hash;
    }

    public int[] getColours(Category category) {
        if (category == Category.SASH) {
            int[] nArray;
            if (this.sashColors == null && this.apiData != null) {
                nArray = (int[])this.apiData.func_76340_b();
            } else {
                int[] nArray2 = new int[3];
                nArray2[0] = 0;
                nArray2[1] = 0;
                nArray = nArray2;
                nArray2[2] = 0;
            }
            return nArray;
        }
        if (category == Category.HAT) {
            return this.capColors;
        }
        if (category == Category.MONOCLE) {
            return this.monocleOffset;
        }
        return null;
    }

    public void setColours(Category category, int[] array) {
        if (category == Category.SASH) {
            this.sashColors = array;
        } else if (category == Category.HAT) {
            this.capColors = array;
        } else if (category == Category.MONOCLE) {
            this.monocleOffset = array;
        }
    }

    public boolean isEnabled(Category category) {
        return this.enabled.contains((Object)category);
    }

    public void setEnabled(Category category, boolean bool) {
        if (bool) {
            this.enabled.add(category);
        } else {
            this.enabled.remove((Object)category);
        }
    }

    public HatType getHatType() {
        if (this.isEnabled(Category.HAT)) {
            switch (this.hatType) {
                case SCOR_HOOD: 
                case TRAINER_CAP: {
                    return this.has(ExtrasContact.Groups.Trainer_Cap) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case PIKA_HOOD: {
                    return this.has(ExtrasContact.Groups.Pikahood) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case EEVEE_HOOD: {
                    return this.has(ExtrasContact.Groups.EeveeHood) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case WIKI: {
                    return this.has(ExtrasContact.Groups.Wiki) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case TOP_HAT: 
                case FEZ: 
                case FEDORA: {
                    return this.has(ExtrasContact.Groups.CompWinner) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case SPHEAL_HAT: {
                    return this.has(ExtrasContact.Groups.SphealHats) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case WELKIN_HAT: {
                    return this.has(ExtrasContact.Groups.Welkin) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case ESPEON_SCARF: {
                    return this.has(ServerCosmetics.ESPEON_SCARF) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case FLAREON_SCARF: {
                    return this.has(ServerCosmetics.FLAREON_SCARF) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case GLACEON_SCARF: {
                    return this.has(ServerCosmetics.GLACEON_SCARF) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case JOLTEON_SCARF: {
                    return this.has(ServerCosmetics.JOLTEON_SCARF) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case LEAFEON_SCARF: {
                    return this.has(ServerCosmetics.LEAFEON_SCARF) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case SYLVEON_SCARF: {
                    return this.has(ServerCosmetics.SYLVEON_SCARF) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case UMBREON_SCARF: {
                    return this.has(ServerCosmetics.UMBREON_SCARF) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case VAPOREON_SCARF: {
                    return this.has(ServerCosmetics.VAPOREON_SCARF) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case SABLEYE_HOOD: {
                    return this.has(ExtrasContact.Groups.AnniversaryHood) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case WITCH: {
                    return this.has(ExtrasContact.Groups.WitchHat) ? this.hatType : (this.hatType = HatType.NONE);
                }
            }
        }
        return HatType.NONE;
    }

    public boolean setHatType(HatType hat) {
        if (hat == HatType.TRAINER_CAP && this.has(ExtrasContact.Groups.Trainer_Cap) || hat == HatType.PIKA_HOOD && this.has(ExtrasContact.Groups.Pikahood) || hat == HatType.EEVEE_HOOD && this.has(ExtrasContact.Groups.EeveeHood) || hat == HatType.SCOR_HOOD && this.has(ExtrasContact.Groups.Trainer_Cap) || hat == HatType.WIKI && this.has(ExtrasContact.Groups.Wiki) || hat == HatType.SPHEAL_HAT && this.has(ExtrasContact.Groups.SphealHats) || hat == HatType.WELKIN_HAT && this.has(ExtrasContact.Groups.Welkin) || hat == HatType.ESPEON_SCARF && this.has(ServerCosmetics.ESPEON_SCARF) || hat == HatType.FLAREON_SCARF && this.has(ServerCosmetics.FLAREON_SCARF) || hat == HatType.GLACEON_SCARF && this.has(ServerCosmetics.GLACEON_SCARF) || hat == HatType.JOLTEON_SCARF && this.has(ServerCosmetics.JOLTEON_SCARF) || hat == HatType.LEAFEON_SCARF && this.has(ServerCosmetics.LEAFEON_SCARF) || hat == HatType.SYLVEON_SCARF && this.has(ServerCosmetics.SYLVEON_SCARF) || hat == HatType.UMBREON_SCARF && this.has(ServerCosmetics.UMBREON_SCARF) || hat == HatType.VAPOREON_SCARF && this.has(ServerCosmetics.VAPOREON_SCARF) || hat == HatType.SABLEYE_HOOD && this.has(ExtrasContact.Groups.AnniversaryHood) || hat == HatType.WITCH && this.has(ExtrasContact.Groups.WitchHat) || this.has(ExtrasContact.Groups.CompWinner) || hat == HatType.NONE) {
            this.hatType = hat;
            return true;
        }
        return false;
    }

    public EnumSet<HatType> getAvailableHats() {
        EnumSet<HatType> set = EnumSet.noneOf(HatType.class);
        if (this.has(ExtrasContact.Groups.Trainer_Cap)) {
            set.add(HatType.TRAINER_CAP);
            set.add(HatType.SCOR_HOOD);
        }
        if (this.has(ExtrasContact.Groups.CompWinner)) {
            set.add(HatType.TOP_HAT);
            set.add(HatType.FEZ);
            set.add(HatType.FEDORA);
        }
        if (this.has(ExtrasContact.Groups.Pikahood)) {
            set.add(HatType.PIKA_HOOD);
        }
        if (this.has(ExtrasContact.Groups.EeveeHood)) {
            set.add(HatType.EEVEE_HOOD);
        }
        if (this.has(ExtrasContact.Groups.Wiki)) {
            set.add(HatType.WIKI);
        }
        if (this.has(ExtrasContact.Groups.SphealHats)) {
            set.add(HatType.SPHEAL_HAT);
        }
        if (this.has(ExtrasContact.Groups.Welkin)) {
            set.add(HatType.WELKIN_HAT);
        }
        if (this.has(ServerCosmetics.ESPEON_SCARF)) {
            set.add(HatType.ESPEON_SCARF);
        }
        if (this.has(ServerCosmetics.FLAREON_SCARF)) {
            set.add(HatType.FLAREON_SCARF);
        }
        if (this.has(ServerCosmetics.GLACEON_SCARF)) {
            set.add(HatType.GLACEON_SCARF);
        }
        if (this.has(ServerCosmetics.JOLTEON_SCARF)) {
            set.add(HatType.JOLTEON_SCARF);
        }
        if (this.has(ServerCosmetics.LEAFEON_SCARF)) {
            set.add(HatType.LEAFEON_SCARF);
        }
        if (this.has(ServerCosmetics.SYLVEON_SCARF)) {
            set.add(HatType.SYLVEON_SCARF);
        }
        if (this.has(ServerCosmetics.UMBREON_SCARF)) {
            set.add(HatType.UMBREON_SCARF);
        }
        if (this.has(ServerCosmetics.VAPOREON_SCARF)) {
            set.add(HatType.VAPOREON_SCARF);
        }
        if (this.has(ExtrasContact.Groups.AnniversaryHood)) {
            set.add(HatType.SABLEYE_HOOD);
        }
        if (this.has(ExtrasContact.Groups.WitchHat)) {
            set.add(HatType.WITCH);
        }
        return set;
    }

    public WingType getWingType() {
        if (this.wingType == WingType.NONE || !this.isEnabled(Category.WINGS)) {
            return WingType.NONE;
        }
        switch (this.wingType) {
            case CHRISTMAS_ARTICUNO: {
                return this.has(ExtrasContact.Groups.ChristmasWings) ? this.wingType : (this.wingType = WingType.NONE);
            }
            case VALENTINES_HEART: {
                return this.has(ExtrasContact.Groups.ValentinesWings) ? this.wingType : (this.wingType = WingType.NONE);
            }
        }
        return WingType.NONE;
    }

    public boolean setWingType(WingType wingType) {
        if (wingType == WingType.CHRISTMAS_ARTICUNO && this.has(ExtrasContact.Groups.ChristmasWings) || wingType == WingType.VALENTINES_HEART && this.has(ExtrasContact.Groups.ValentinesWings) || wingType == WingType.NONE) {
            this.wingType = wingType;
            return true;
        }
        return false;
    }

    public MonocleType getMonocleType() {
        if (this.isEnabled(Category.MONOCLE)) {
            switch (this.monocleType) {
                case GOLD_MONOCLE: 
                case BLACK_MONOCLE: {
                    return this.has(ExtrasContact.Groups.Monocle_Gold) ? this.monocleType : (this.monocleType = MonocleType.NONE);
                }
                case QUAGSIRE_MASK: {
                    return this.has(ExtrasContact.Groups.HaaMask) ? this.monocleType : (this.monocleType = MonocleType.NONE);
                }
                case QUARANTINE_MASK: {
                    return this.has(ExtrasContact.Groups.QuarantineMask) ? this.monocleType : (this.monocleType = MonocleType.NONE);
                }
            }
        }
        return MonocleType.NONE;
    }

    public boolean setMonocleType(MonocleType monocle) {
        if (monocle == MonocleType.GOLD_MONOCLE && this.has(ExtrasContact.Groups.Monocle_Gold) || monocle == MonocleType.BLACK_MONOCLE && this.has(ExtrasContact.Groups.Monocle_Gold) || monocle == MonocleType.QUAGSIRE_MASK && this.has(ExtrasContact.Groups.HaaMask) || monocle == MonocleType.QUARANTINE_MASK && this.has(ExtrasContact.Groups.QuarantineMask) || monocle == MonocleType.NONE) {
            this.monocleType = monocle;
            return true;
        }
        return false;
    }

    public EnumSet<MonocleType> getAvailableMonocles() {
        EnumSet<MonocleType> set = EnumSet.noneOf(MonocleType.class);
        if (this.has(ExtrasContact.Groups.Monocle_Gold)) {
            set.add(MonocleType.GOLD_MONOCLE);
        }
        if (this.has(ExtrasContact.Groups.Monocle_Gold)) {
            set.add(MonocleType.BLACK_MONOCLE);
        }
        if (this.has(ExtrasContact.Groups.HaaMask)) {
            set.add(MonocleType.QUAGSIRE_MASK);
        }
        if (this.has(ExtrasContact.Groups.QuarantineMask)) {
            set.add(MonocleType.QUARANTINE_MASK);
        }
        return set;
    }

    public SashType getSashType() {
        if (this.isEnabled(Category.SASH)) {
            if (this.sashType == null) {
                return this.has(ExtrasContact.Groups.Rainbow_Sash) ? SashType.RAINBOW : (this.has(ExtrasContact.Groups.Admin, ExtrasContact.Groups.Junior_Admin) ? SashType.RANK_ADMIN : (this.has(ExtrasContact.Groups.Developer) ? SashType.RANK_DEV : (this.has(ExtrasContact.Groups.Modeler) ? SashType.RANK_MODELER : (this.has(ExtrasContact.Groups.Support) ? SashType.RANK_SUPPORT : (this.has(ExtrasContact.Groups.NitroBooster) ? SashType.BOOSTER : (this.has(ExtrasContact.Groups.Sash) ? SashType.REGULAR : SashType.NONE))))));
            }
            switch (this.sashType) {
                case REGULAR: {
                    return this.has(ExtrasContact.Groups.Sash) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RAINBOW: {
                    return this.has(ExtrasContact.Groups.Rainbow_Sash) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_ADMIN: {
                    return this.has(ExtrasContact.Groups.Admin) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_JR: {
                    return this.has(ExtrasContact.Groups.Junior_Admin) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_DEV: {
                    return this.has(ExtrasContact.Groups.Developer) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_MODELER: {
                    return this.has(ExtrasContact.Groups.Modeler) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_SUPPORT: {
                    return this.has(ExtrasContact.Groups.Support) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case BOOSTER: {
                    return this.has(ExtrasContact.Groups.NitroBooster) ? this.sashType : (this.sashType = SashType.NONE);
                }
            }
        }
        return SashType.NONE;
    }

    public boolean setSashType(SashType sash) {
        if (sash == SashType.REGULAR && this.has(ExtrasContact.Groups.Sash) || sash == SashType.RAINBOW && this.has(ExtrasContact.Groups.Rainbow_Sash) || sash == SashType.RANK_ADMIN && this.has(ExtrasContact.Groups.Admin) || sash == SashType.RANK_JR && this.has(ExtrasContact.Groups.Junior_Admin) || sash == SashType.RANK_DEV && this.has(ExtrasContact.Groups.Developer) || sash == SashType.RANK_MODELER && this.has(ExtrasContact.Groups.Modeler) || sash == SashType.RANK_SUPPORT && this.has(ExtrasContact.Groups.Support) || sash == SashType.BOOSTER && this.has(ExtrasContact.Groups.NitroBooster) || sash == SashType.NONE) {
            this.sashType = sash;
            return true;
        }
        return false;
    }

    public EnumSet<SashType> getAvailableSashs() {
        EnumSet<SashType> set = EnumSet.noneOf(SashType.class);
        if (this.has(ExtrasContact.Groups.Sash)) {
            set.add(SashType.REGULAR);
        }
        if (this.has(ExtrasContact.Groups.Rainbow_Sash)) {
            set.add(SashType.RAINBOW);
        }
        if (this.has(ExtrasContact.Groups.Admin)) {
            set.add(SashType.RANK_ADMIN);
        }
        if (this.has(ExtrasContact.Groups.Junior_Admin)) {
            set.add(SashType.RANK_JR);
        }
        if (this.has(ExtrasContact.Groups.Developer)) {
            set.add(SashType.RANK_DEV);
        }
        if (this.has(ExtrasContact.Groups.Modeler)) {
            set.add(SashType.RANK_MODELER);
        }
        if (this.has(ExtrasContact.Groups.Support)) {
            set.add(SashType.RANK_SUPPORT);
        }
        if (this.has(ExtrasContact.Groups.NitroBooster)) {
            set.add(SashType.BOOSTER);
        }
        return set;
    }

    public EnumSet<WingType> getAvailableWings() {
        EnumSet<WingType> set = EnumSet.noneOf(WingType.class);
        if (this.has(ExtrasContact.Groups.ChristmasWings)) {
            set.add(WingType.CHRISTMAS_ARTICUNO);
        }
        if (this.has(ExtrasContact.Groups.ValentinesWings)) {
            set.add(WingType.VALENTINES_HEART);
        }
        return set;
    }

    public Set<Species> getAvailableTextures() {
        HashSet set = Sets.newHashSet();
        if (this.has(ExtrasContact.Groups.Spectral_Jeweller)) {
            set.add(PixelmonSpecies.GASTLY.getValueUnsafe());
            set.add(PixelmonSpecies.HAUNTER.getValueUnsafe());
            set.add(PixelmonSpecies.GENGAR.getValueUnsafe());
        }
        if (this.has(ExtrasContact.Groups.Shadow_Lugia)) {
            set.add(PixelmonSpecies.LUGIA.getValueUnsafe());
            set.add(PixelmonSpecies.HOOH.getValueUnsafe());
        }
        if (this.has(ExtrasContact.Groups.Wobbuffet)) {
            set.add(PixelmonSpecies.WOBBUFFET.getValueUnsafe());
        }
        if (this.has(ExtrasContact.Groups.PDSentret)) {
            set.add(PixelmonSpecies.SENTRET.getValueUnsafe());
        }
        if (this.has(ExtrasContact.Groups.ELGreninja)) {
            set.add(PixelmonSpecies.GRENINJA.getValueUnsafe());
        }
        if (this.has(ExtrasContact.Groups.SFXMewtwo)) {
            set.add(PixelmonSpecies.MEWTWO.getValueUnsafe());
        }
        if (this.has(ExtrasContact.Groups.CinderaceGoku)) {
            set.add(PixelmonSpecies.CINDERACE.getValueUnsafe());
        }
        if (this.has(ExtrasContact.Groups.BugcatcherMothim)) {
            set.add(PixelmonSpecies.MOTHIM.getValueUnsafe());
        }
        return set;
    }

    public boolean canSeeTexture(Species pokemon) {
        if (pokemon.is(PixelmonSpecies.GASTLY, PixelmonSpecies.HAUNTER, PixelmonSpecies.GENGAR)) {
            return this.has(ExtrasContact.Groups.Spectral_Jeweller);
        }
        if (pokemon.is(PixelmonSpecies.LUGIA, PixelmonSpecies.HOOH)) {
            return this.has(ExtrasContact.Groups.Shadow_Lugia);
        }
        if (pokemon.is(PixelmonSpecies.WOBBUFFET)) {
            return this.has(ExtrasContact.Groups.Wobbuffet);
        }
        if (pokemon.is(PixelmonSpecies.SENTRET)) {
            return this.has(ExtrasContact.Groups.PDSentret);
        }
        if (pokemon.is(PixelmonSpecies.GRENINJA)) {
            return this.has(ExtrasContact.Groups.ELGreninja);
        }
        if (pokemon.is(PixelmonSpecies.MEWTWO)) {
            return this.has(ExtrasContact.Groups.SFXMewtwo);
        }
        if (pokemon.is(PixelmonSpecies.LUCARIO)) {
            return this.has(ExtrasContact.Groups.IRWLucario);
        }
        if (pokemon.is(PixelmonSpecies.CINDERACE)) {
            return this.has(ExtrasContact.Groups.CinderaceGoku);
        }
        if (pokemon.is(PixelmonSpecies.MOTHIM)) {
            return this.has(ExtrasContact.Groups.BugcatcherMothim);
        }
        if (pokemon.is(PixelmonSpecies.SPHEAL)) {
            return this.has(ExtrasContact.Groups.ChristmasSpheal);
        }
        return false;
    }

    public void checkPokemon(Pokemon pokemon) {
        if (!this.isReady()) {
            return;
        }
        if (pokemon.getForm().isForm("online") && !this.canSeeTexture(pokemon.getSpecies())) {
            pokemon.setForm(pokemon.getSpecies().getDefaultForm());
        }
    }

    public boolean setRobeType(RobeType type) {
        if (type == RobeType.WIZARD && this.has(ExtrasContact.Groups.Trainer_Cap) || type == RobeType.ALTER && this.has(ExtrasContact.Groups.AlterRobe) || type == RobeType.STRIKE && this.has(ExtrasContact.Groups.StrikeRobe) || type == RobeType.ASHEN && this.has(ExtrasContact.Groups.AshenRobe) || type == RobeType.WINTER_CLOAK && this.has(ExtrasContact.Groups.Trainer_Cap) || type == RobeType.FROSLASS_YUKATA && this.has(ExtrasContact.Groups.Froslass_Yukata) || type == RobeType.DROWNED && this.has(ServerCosmetics.DROWNED_ROBE) || type == RobeType.NONE) {
            this.robeType = type;
            return true;
        }
        return false;
    }

    public RobeType getRobeType() {
        if (this.isEnabled(Category.ROBE)) {
            switch (this.robeType) {
                case ALTER: {
                    return this.has(ExtrasContact.Groups.AlterRobe) ? this.robeType : (this.robeType = RobeType.NONE);
                }
                case STRIKE: {
                    return this.has(ExtrasContact.Groups.StrikeRobe) ? this.robeType : (this.robeType = RobeType.NONE);
                }
                case ASHEN: {
                    return this.has(ExtrasContact.Groups.AshenRobe) ? this.robeType : (this.robeType = RobeType.NONE);
                }
                case WIZARD: {
                    return this.has(ExtrasContact.Groups.Trainer_Cap) ? this.robeType : (this.robeType = RobeType.NONE);
                }
                case DROWNED: {
                    return this.has(ServerCosmetics.DROWNED_ROBE) ? this.robeType : (this.robeType = RobeType.NONE);
                }
                case WINTER_CLOAK: {
                    return this.has(ExtrasContact.Groups.Trainer_Cap) ? this.robeType : (this.robeType = RobeType.NONE);
                }
                case FROSLASS_YUKATA: {
                    return this.has(ExtrasContact.Groups.Froslass_Yukata) ? this.robeType : (this.robeType = RobeType.NONE);
                }
            }
        }
        return RobeType.NONE;
    }

    public EnumSet<RobeType> getAvailableRobes() {
        EnumSet<RobeType> set = EnumSet.noneOf(RobeType.class);
        if (this.has(ExtrasContact.Groups.Trainer_Cap)) {
            set.add(RobeType.WIZARD);
        }
        if (this.has(ExtrasContact.Groups.AlterRobe)) {
            set.add(RobeType.ALTER);
        }
        if (this.has(ExtrasContact.Groups.StrikeRobe)) {
            set.add(RobeType.STRIKE);
        }
        if (this.has(ExtrasContact.Groups.AshenRobe)) {
            set.add(RobeType.ASHEN);
        }
        if (this.has(ExtrasContact.Groups.Trainer_Cap)) {
            set.add(RobeType.WINTER_CLOAK);
        }
        if (this.has(ExtrasContact.Groups.Froslass_Yukata)) {
            set.add(RobeType.FROSLASS_YUKATA);
        }
        if (this.has(ServerCosmetics.DROWNED_ROBE)) {
            set.add(RobeType.DROWNED);
        }
        return set;
    }

    public boolean hasBoostedNecklace() {
        return this.has(ExtrasContact.Groups.NitroBooster);
    }

    public SphealType getSphealType() {
        return this.sphealType == null ? SphealType.DEFAULT : this.sphealType;
    }

    public void setSphealType(SphealType type) {
        this.sphealType = type;
    }

    public void randomiseSpheal() {
        boolean shiny = RandomHelper.getRandomChance(10);
        boolean stitched = RandomHelper.getRandomChance();
        this.sphealType = SphealType.from(shiny, stitched);
    }

    final boolean has(ExtrasContact.Groups ... groups) {
        if (this.apiData != null) {
            for (ExtrasContact.Groups group : groups) {
                if (!((EnumSet)this.apiData.func_76341_a()).contains((Object)group)) continue;
                return true;
            }
        }
        return false;
    }

    final boolean has(ServerCosmetics ... cosmetics) {
        if (this.serverCosmetics != null) {
            for (ServerCosmetics cosmetic : cosmetics) {
                if (!this.serverCosmetics.contains((Object)cosmetic)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum Category {
        SASH,
        HAT,
        ROBE,
        MONOCLE,
        WINGS;

    }

    public static enum WingType {
        NONE,
        CHRISTMAS_ARTICUNO,
        VALENTINES_HEART;

    }

    public static enum SphealType {
        DEFAULT(false, false),
        SHINY(true, false),
        STITCHED(false, true),
        SHINY_STITCHED(true, true);

        public final boolean shiny;
        public final boolean stitched;

        private SphealType(boolean shiny, boolean stitched) {
            this.shiny = shiny;
            this.stitched = stitched;
        }

        public static SphealType from(boolean shiny, boolean stitched) {
            for (SphealType type : SphealType.values()) {
                if (type.shiny != shiny || type.stitched != stitched) continue;
                return type;
            }
            return DEFAULT;
        }
    }

    public static enum RobeType {
        NONE,
        WIZARD,
        DROWNED,
        ALTER,
        STRIKE,
        ASHEN,
        WINTER_CLOAK,
        FROSLASS_YUKATA;

    }

    public static enum SashType {
        NONE,
        REGULAR,
        RAINBOW,
        RANK_ADMIN,
        RANK_JR,
        RANK_DEV,
        RANK_MODELER,
        RANK_SUPPORT,
        BOOSTER;

    }

    public static enum MonocleType {
        NONE(-1),
        GOLD_MONOCLE(0),
        BLACK_MONOCLE(1),
        QUAGSIRE_MASK(2),
        QUARANTINE_MASK(3);

        public final int id;

        private MonocleType(int id) {
            this.id = id;
        }

        public static MonocleType getFromId(int id) {
            for (MonocleType monocle : MonocleType.values()) {
                if (monocle.id != id) continue;
                return monocle;
            }
            return NONE;
        }
    }

    public static enum HatType {
        NONE(-1),
        TOP_HAT(0),
        FEZ(1),
        FEDORA(2),
        TRAINER_CAP(4),
        PIKA_HOOD(5),
        WIKI(6),
        EEVEE_HOOD(7),
        SCOR_HOOD(8),
        SPHEAL_HAT(9),
        ESPEON_SCARF(10),
        FLAREON_SCARF(11),
        GLACEON_SCARF(12),
        JOLTEON_SCARF(13),
        LEAFEON_SCARF(14),
        SYLVEON_SCARF(15),
        UMBREON_SCARF(16),
        VAPOREON_SCARF(17),
        WELKIN_HAT(18),
        SABLEYE_HOOD(19),
        WITCH(92);

        public final int id;

        private HatType(int id) {
            this.id = id;
        }

        public static HatType getFromId(int id) {
            for (HatType hat : HatType.values()) {
                if (hat.id != id) continue;
                return hat;
            }
            return NONE;
        }

        public static HatType getFromName(String name) {
            for (HatType hat : HatType.values()) {
                if (!hat.name().replace("_", "").equalsIgnoreCase(name)) continue;
                return hat;
            }
            return NONE;
        }
    }
}

