/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client;

import com.pixelmonmod.pixelmon.api.util.helpers.MapHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.quests.quest.StageIcon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;

public class QuestProgressClientData {
    protected String filename;
    protected UUID identifier;
    protected QuestColor color;
    protected boolean specialColor;
    protected boolean abandonable;
    protected boolean repeatable;
    protected int weight;
    protected String name;
    protected String desc;
    protected ArrayList<ObjectiveDetail> objectives;
    protected ArrayList<QuestMarker> markers;
    protected StageIcon icon = StageIcon.EXCLAMATION_MARK;
    protected boolean readyForTurnIn;
    protected boolean complete;
    protected boolean failed;
    protected HashMap<String, Long> dataLongMap;
    protected HashMap<String, String> dataStringMap;
    protected boolean visible;

    public QuestProgressClientData() {
    }

    public QuestProgressClientData(PacketBuffer buf) {
        this.read(buf);
    }

    public void read(PacketBuffer buf) {
        int i;
        this.filename = buf.func_218666_n();
        this.identifier = buf.func_179253_g();
        this.dataLongMap = MapHelper.readStringLongMapFromByteBuf(buf);
        this.dataStringMap = MapHelper.readStringStringMapFromByteBuf(buf);
        this.visible = buf.readBoolean();
        if (this.visible) {
            this.specialColor = buf.readBoolean();
            this.color = this.specialColor ? new QuestColor(buf.readInt(), 0, 0) : new QuestColor(buf.readInt());
            this.abandonable = buf.readBoolean();
            this.repeatable = buf.readBoolean();
            this.weight = buf.readInt();
            this.name = buf.func_218666_n();
            this.desc = buf.func_218666_n();
            this.objectives = new ArrayList();
            int sizeA = buf.readInt();
            for (i = 0; i < sizeA; ++i) {
                ObjectiveDetail od;
                if (!buf.readBoolean() || (od = new ObjectiveDetail(buf.func_218666_n(), buf.readShort(), buf.readShort(), buf.readBoolean())).isComplete()) continue;
                this.objectives.add(od);
            }
        }
        this.markers = new ArrayList();
        int sizeB = buf.readInt();
        for (i = 0; i < sizeB; ++i) {
            this.markers.add(new QuestMarker(buf));
        }
        this.icon = StageIcon.getIcon(buf.readByte());
        this.readyForTurnIn = buf.readBoolean();
        this.complete = buf.readBoolean();
        this.failed = buf.readBoolean();
    }

    public void write(QuestProgress progress, PacketBuffer buf) {
        Quest quest = progress.getQuest();
        boolean detail = progress.isComplete() || progress.getStage() >= quest.getActiveStage();
        buf.func_180714_a(quest.getFilename());
        buf.func_179252_a(progress.getIdentifier());
        MapHelper.writeStringLongMapToByteBuf(buf, progress.getDataLongMap());
        MapHelper.writeStringStringMapToByteBuf(buf, progress.getDataStringMap());
        buf.writeBoolean(detail);
        if (detail) {
            buf.writeBoolean(quest.getColor().getR() < 0);
            buf.writeInt(quest.getColor().getR() < 0 ? quest.getColor().getR() : quest.getColor().getRGB());
            buf.writeBoolean(progress.isAbandonable());
            buf.writeBoolean(quest.isRepeatable());
            buf.writeInt(quest.getWeight());
            buf.func_180714_a(quest.getUnlocalizedString("name", progress));
            buf.func_180714_a(quest.getUnlocalizedString(progress.isComplete() ? "desc-X" : "desc-" + progress.getStage(), progress));
            Stage stage = progress.getCurrentStage();
            buf.writeInt(progress.isComplete() ? 0 : stage.getParsedObjectives().size());
            int i = 0;
            if (!progress.isComplete()) {
                for (Objective objective : stage.getParsedObjectives()) {
                    String name = quest.getUnlocalizedString("stage-" + stage.getStage() + "-" + i, progress);
                    if (name == null || name.isEmpty()) {
                        buf.writeBoolean(false);
                    } else {
                        buf.writeBoolean(true);
                        buf.func_180714_a(name);
                        buf.writeShort(progress.getObjectiveQuantityComplete(i));
                        buf.writeShort(progress.getObjectiveTotalQuantity(i));
                        buf.writeBoolean(progress.isObjectiveComplete(i));
                    }
                    ++i;
                }
            }
        }
        ArrayList<QuestMarker> markers = progress.getMarkers();
        buf.writeInt(markers.size());
        for (QuestMarker marker : markers) {
            marker.write(buf);
        }
        buf.writeByte(progress.getCurrentStage().getIcon().ordinal());
        buf.writeBoolean(progress.getNextStage() == null);
        buf.writeBoolean(progress.isComplete());
        buf.writeBoolean(progress.isFailed());
    }
}

