/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Overcoat;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.IEquippable;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SafetyGogglesItem
extends HeldItem
implements IEquippable {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/equippables/safety_goggles.png");

    public SafetyGogglesItem() {
        super(EnumHeldItems.safetyGoggles, new Item.Properties().func_200917_a(1));
    }

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (Overcoat.isPowderMove(a)) {
            String nickname = pokemon.getNickname();
            pokemon.bc.sendToAll("pixelmon.abilities.activated", nickname, pokemon.getHeldItem().getLocalizedName());
            pokemon.bc.sendToAll("pixelmon.battletext.noeffect", nickname);
            return false;
        }
        return true;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.HEAD;
    }

    @Override
    public String getEquippableModelKey() {
        return "safety_goggles";
    }

    @Override
    public ResourceLocation getEquippableTexture() {
        return TEXTURE;
    }

    @Override
    public Item getEquippableItem() {
        return this;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("Unequippable")) && this.getEquipmentSlot(stack) == armorType;
    }
}

