/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.blocks.ZygardeCellBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ZygardeCellTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ZygardeCubeItem
extends PixelmonItem {
    public ZygardeCubeItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("pixelmon.items.zygarde_cube.tooltip.cells", new Object[]{ZygardeCubeItem.getCellCount(stack)}));
        tooltip.add((ITextComponent)new TranslationTextComponent("pixelmon.items.zygarde_cube.tooltip.cores", new Object[]{ZygardeCubeItem.getCoreCount(stack)}));
        Set<CoreType> cores = ZygardeCubeItem.getCoreTypes(stack);
        if (!cores.isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("pixelmon.items.zygarde_cube.tooltip.moves"));
            for (CoreType type : cores) {
                if (type.getMove() == null) continue;
                tooltip.add((ITextComponent)new StringTextComponent(" - " + type.getMove().getLocalizedName()));
            }
        }
        super.func_77624_a(stack, world, tooltip, advanced);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Hand hand = context.func_221531_n();
        World worldIn = context.func_195991_k();
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() instanceof ZygardeCellBlock) {
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() != this) {
                return ActionResultType.PASS;
            }
            ZygardeCellTileEntity cell = BlockHelper.getTileEntity(ZygardeCellTileEntity.class, (IBlockReader)worldIn, pos);
            if (cell != null) {
                if (cell.isPermanent()) {
                    if (cell.addEncounter(player.func_110124_au())) {
                        if (ZygardeCubeItem.registerCell(cell, state, player, stack)) {
                            ChatHandler.sendChat((Entity)player, "pixelmon.items.zygarde_cube.pickup", new Object[0]);
                        }
                    } else {
                        ChatHandler.sendChat((Entity)player, "pixelmon.items.zygarde_cube.encountered", new TranslationTextComponent(state.func_177230_c().func_149739_a() + ""));
                    }
                } else if (worldIn.func_217377_a(pos, false) && ZygardeCubeItem.registerCell(cell, state, player, stack)) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.items.zygarde_cube.pickup", new Object[0]);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public static int getCellCount(ItemStack stack) {
        CompoundNBT compound = stack.func_190925_c("cells");
        return compound.func_74765_d("Count");
    }

    public static void setCellCount(ItemStack stack, int count) {
        if (count > 200) {
            count = 200;
        }
        if (count < 0) {
            count = 0;
        }
        CompoundNBT compound = stack.func_190925_c("cells");
        compound.func_74777_a("Count", (short)count);
    }

    public static int getCoreCount(ItemStack stack) {
        CompoundNBT compound = stack.func_190925_c("cells");
        return compound.func_74765_d("CoreCount");
    }

    public static void setCoreCount(ItemStack stack, int count) {
        if (count > 5) {
            count = 5;
        }
        if (count < 0) {
            count = 0;
        }
        CompoundNBT compound = stack.func_190925_c("cells");
        compound.func_74777_a("CoreCount", (short)count);
    }

    public static boolean hasCore(ItemStack stack, CoreType type) {
        CompoundNBT compound = stack.func_190925_c("cells");
        return compound.func_74767_n("Core" + type.ordinal());
    }

    public static void addCore(ItemStack stack, CoreType type) {
        ZygardeCubeItem.setCoreCount(stack, ZygardeCubeItem.getCoreCount(stack) + 1);
        CompoundNBT compound = stack.func_190925_c("cells");
        compound.func_74757_a("Core" + type.ordinal(), true);
    }

    public static Set<CoreType> getCoreTypes(ItemStack stack) {
        EnumSet<CoreType> set = EnumSet.allOf(CoreType.class);
        set.removeIf(type -> !ZygardeCubeItem.hasCore(stack, type));
        set.remove((Object)CoreType.RANDOM);
        return set;
    }

    public static boolean registerCell(ZygardeCellTileEntity te, BlockState state, PlayerEntity player, ItemStack stack) {
        boolean core;
        boolean bl = core = state.func_177230_c() == PixelmonBlocks.zygarde_core;
        if (core) {
            if (te.getCoreType() == CoreType.RANDOM) {
                EnumSet<CoreType> cores = EnumSet.allOf(CoreType.class);
                cores.remove((Object)CoreType.RANDOM);
                cores.removeAll(ZygardeCubeItem.getCoreTypes(stack));
                if (cores.isEmpty()) {
                    cores = EnumSet.allOf(CoreType.class);
                    cores.remove((Object)CoreType.RANDOM);
                }
                ZygardeCubeItem.addCore(stack, RandomHelper.getRandomElementFromArray(cores.toArray(new CoreType[0])));
                return true;
            }
            if (ZygardeCubeItem.hasCore(stack, te.getCoreType())) {
                ChatHandler.sendChat((Entity)player, "pixelmon.items.zygarde_cube.encountered", new TranslationTextComponent(state.func_177230_c().func_149739_a() + ""));
                return false;
            }
            ZygardeCubeItem.addCore(stack, te.getCoreType());
            return true;
        }
        ZygardeCubeItem.setCellCount(stack, ZygardeCubeItem.getCellCount(stack) + 1);
        return true;
    }

    public static enum CoreType {
        RANDOM(() -> null),
        CORE_ENFORCER(() -> AttackRegistry.CORE_ENFORCER.orElse(null)),
        THOUSAND_ARROWS(() -> AttackRegistry.THOUSAND_ARROWS.orElse(null)),
        THOUSAND_WAVES(() -> AttackRegistry.THOUSAND_WAVES.orElse(null)),
        EXTREME_SPEED(() -> AttackRegistry.EXTREME_SPEED.orElse(null)),
        DRAGON_DANCE(() -> AttackRegistry.DRAGON_DANCE.orElse(null));

        private static final CoreType[] VALUES;
        private final Supplier<ImmutableAttack> move;

        private CoreType(Supplier<ImmutableAttack> moveName) {
            this.move = moveName;
        }

        public ImmutableAttack getMove() {
            return this.move.get();
        }

        public static CoreType[] getTypes() {
            return new CoreType[]{CORE_ENFORCER, THOUSAND_ARROWS, THOUSAND_WAVES, EXTREME_SPEED, DRAGON_DANCE};
        }

        public static CoreType fromIndex(int index) {
            if (index < 0 || index >= VALUES.length) {
                return RANDOM;
            }
            return VALUES[index];
        }

        static {
            VALUES = CoreType.values();
        }
    }
}

