/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.RarityTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;

public class LureItem
extends PixelmonItem
implements RarityTweak {
    public LureType type;
    public LureStrength strength;

    public LureItem(LureType type, LureStrength strength) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200918_c(128).setNoRepair());
        this.type = type;
        this.strength = strength;
    }

    @Override
    public float getMultiplier(AbstractSpawner spawner, SpawnInfo spawnInfo, float sum, float rarity) {
        if (!(spawnInfo instanceof SpawnInfoPokemon)) {
            return 1.0f;
        }
        SpawnInfoPokemon spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo;
        RegistryValue specSpecies = spawnInfoPokemon.getPokemonSpec().getValue(SpeciesRequirement.class).orElse(null);
        if (spawnInfoPokemon.getPokemonSpec() == null || specSpecies == null || !specSpecies.isInitialized()) {
            return 1.0f;
        }
        Species species = spawnInfoPokemon.getSpecies();
        Stats form = spawnInfoPokemon.getPokemonSpec().getValue(FormRequirement.class).map(species::getForm).orElse(species.getDefaultForm());
        if (this.type.type != null && form.getTypes().contains(this.type.type)) {
            return this.strength.multiplier;
        }
        if (this.type == LureType.SHINY && (spawnInfoPokemon.spawnSpecificShinyRate != null && spawnInfoPokemon.spawnSpecificShinyRate.floatValue() == 1.0f || spawnInfo.set.setSpecificShinyRate != null && spawnInfo.set.setSpecificShinyRate.floatValue() == 1.0f)) {
            return this.strength.multiplier;
        }
        return 1.0f;
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Override
    public String getTooltipText() {
        String translatedType = I18n.func_135052_a((String)("type." + this.type.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
        if (this.type != LureType.HA && this.type != LureType.SHINY) {
            return I18n.func_135052_a((String)("lure." + this.strength.name().toLowerCase(Locale.ROOT) + ".normal.tooltip"), (Object[])new Object[]{translatedType});
        }
        return I18n.func_135052_a((String)("lure." + this.strength.name().toLowerCase(Locale.ROOT) + ".special.tooltip"), (Object[])new Object[]{translatedType});
    }

    public static enum LureStrength {
        WEAK(1.5f),
        STRONG(3.0f);

        public float multiplier;

        private LureStrength(float multiplier) {
            this.multiplier = multiplier;
        }
    }

    public static enum LureType {
        NORMAL(Element.NORMAL),
        FIRE(Element.FIRE),
        WATER(Element.WATER),
        ELECTRIC(Element.ELECTRIC),
        GRASS(Element.GRASS),
        ICE(Element.ICE),
        FIGHTING(Element.FIGHTING),
        POISON(Element.POISON),
        GROUND(Element.GROUND),
        FLYING(Element.FLYING),
        PSYCHIC(Element.PSYCHIC),
        BUG(Element.BUG),
        ROCK(Element.ROCK),
        GHOST(Element.GHOST),
        DRAGON(Element.DRAGON),
        DARK(Element.DARK),
        STEEL(Element.STEEL),
        FAIRY(Element.FAIRY),
        SHINY,
        HA;

        public Element type;

        private LureType() {
            this.type = null;
        }

        private LureType(Element type) {
            this.type = type;
        }
    }
}

