/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.daycare.DayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareConditionStatusResponsePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.UpdateDayCareBoxPacket;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class IsiHourglassItem
extends PixelmonItem {
    private final HourGlassType type;

    public IsiHourglassItem(HourGlassType type) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i));
        this.type = type;
    }

    public HourGlassType getType() {
        return this.type;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos = pos.func_177972_a(context.func_196000_l()), facing, stack)) {
            return ActionResultType.FAIL;
        }
        if (stack.func_190916_E() <= 0) {
            return ActionResultType.FAIL;
        }
        if (worldIn.func_180495_p(pos).func_196953_a(new BlockItemUseContext(context))) {
            BlockState state = ((Block)ForgeRegistries.BLOCKS.getValue(this.getRegistryName())).func_196258_a(new BlockItemUseContext(context));
            worldIn.func_180501_a(pos, state, 8);
            state = worldIn.func_180495_p(pos);
            state.func_177230_c().func_180633_a(worldIn, pos, state, (LivingEntity)playerIn, stack);
            if (!playerIn.func_184812_l_()) {
                if (stack.func_190916_E() <= 1) {
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                } else {
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static enum HourGlassType {
        COPPER{

            @Override
            public boolean handle(ServerPlayerEntity player, int clicked, int ... boxes) {
                PlayerPartyStorage party = StorageProxy.getParty(player);
                PlayerDayCare dayCare = party.getDayCare();
                DayCareBox dayCareBox = dayCare.getOrCreateBox(boxes[clicked]).orElse(null);
                if (dayCareBox == null || dayCareBox.isEmpty() || dayCareBox.hasBreedingBegun()) {
                    return false;
                }
                DayCareCondition nextCondition = dayCareBox.getNextCondition();
                if (nextCondition == null) {
                    return false;
                }
                DayCareRequirement dayCareRequirement = nextCondition.getNextRequirement().orElse(null);
                if (dayCareRequirement == null) {
                    return false;
                }
                nextCondition.skipRequirement(dayCareRequirement);
                if (nextCondition.isComplete()) {
                    dayCareBox.completeCondition(nextCondition);
                    if (dayCareBox.canBreedingBegin()) {
                        dayCareBox.beginBreeding();
                    }
                }
                NetworkHelper.sendPacket(player, new UpdateDayCareBoxPacket(dayCareBox));
                return true;
            }
        }
        ,
        SILVER{

            @Override
            public boolean handle(ServerPlayerEntity player, int clicked, int ... boxes) {
                PlayerPartyStorage party = StorageProxy.getParty(player);
                PlayerDayCare dayCare = party.getDayCare();
                DayCareBox dayCareBox = dayCare.getOrCreateBox(boxes[clicked]).orElse(null);
                if (dayCareBox == null || dayCareBox.isEmpty() || !dayCareBox.hasBreedingBegun() || dayCareBox.getPercentComplete() >= 100.0) {
                    return false;
                }
                dayCareBox.setHourglassesUsed(dayCareBox.getHourglassesUsed() + 1);
                NetworkHelper.sendPacket(player, new UpdateDayCareBoxPacket(dayCareBox));
                return true;
            }
        }
        ,
        GOLD{

            @Override
            public boolean handle(ServerPlayerEntity player, int clicked, int ... boxes) {
                PlayerPartyStorage party = StorageProxy.getParty(player);
                PlayerDayCare dayCare = party.getDayCare();
                DayCareBox dayCareBox = dayCare.getOrCreateBox(boxes[clicked]).orElse(null);
                if (dayCareBox == null || dayCareBox.isEmpty() || dayCareBox.getPercentComplete() >= 100.0) {
                    return false;
                }
                dayCareBox.complete();
                NetworkHelper.sendPacket(player, new DayCareConditionStatusResponsePacket(dayCareBox.getBoxId(), StringTextComponent.field_240750_d_, true));
                NetworkHelper.sendPacket(player, new UpdateDayCareBoxPacket(dayCareBox));
                return true;
            }
        }
        ,
        DIAMOND{

            @Override
            public boolean handle(ServerPlayerEntity player, int clicked, int ... boxes) {
                PlayerPartyStorage party = StorageProxy.getParty(player);
                PlayerDayCare dayCare = party.getDayCare();
                for (int box : boxes) {
                    DayCareBox dayCareBox = dayCare.getOrCreateBox(box).orElse(null);
                    if (dayCareBox == null || dayCareBox.isEmpty() || dayCareBox.getPercentComplete() >= 100.0) continue;
                    dayCareBox.complete();
                    dayCareBox.getEgg().getStats().setIVs(new IVStore(31, 31, 31, 31, 31, 31));
                    dayCareBox.getEgg().setFriendship(255);
                    dayCareBox.getEgg().addRibbon(RibbonRegistry.DAY_CARE.getValueUnsafe());
                    party.setNeedsSaving();
                    NetworkHelper.sendPacket(player, new DayCareConditionStatusResponsePacket(dayCareBox.getBoxId(), StringTextComponent.field_240750_d_, true));
                    NetworkHelper.sendPacket(player, new UpdateDayCareBoxPacket(dayCareBox));
                }
                return true;
            }
        };


        public abstract boolean handle(ServerPlayerEntity var1, int var2, int ... var3);
    }
}

