/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.boss.DropSet;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class AbstractHoldsItemsEntity
extends AbstractMovesEntity {
    boolean dropped = false;

    public AbstractHoldsItemsEntity(EntityType<? extends AbstractHoldsItemsEntity> type, World par1World) {
        super((EntityType<? extends AbstractMovesEntity>)type, par1World);
    }

    public void func_70645_a(DamageSource cause) {
        PixelmonEntity pix;
        if (cause.func_76364_f() instanceof PixelmonEntity && this.getBossTier().isBoss() && !this.field_70170_p.field_72995_K) {
            pix = (PixelmonEntity)cause.func_76364_f();
            if (pix.getOwner() != null && !this.dropped) {
                this.dropBossItems((ServerPlayerEntity)pix.getOwner());
                this.dropped = true;
            } else if (pix.battleController != null && !this.dropped) {
                pix.battleController.participants.stream().filter(p -> p instanceof PlayerParticipant).forEach(p -> {
                    this.dropBossItems(((PlayerParticipant)p).player);
                    this.dropped = true;
                });
            }
        }
        if (cause.func_76364_f() instanceof PixelmonEntity && this.getBossTier().isNotBoss() && !this.field_70170_p.field_72995_K) {
            pix = (PixelmonEntity)cause.func_76364_f();
            if (pix.getOwner() != null && !this.dropped) {
                this.dropNormalItems((ServerPlayerEntity)pix.getOwner());
                this.dropped = true;
            } else if (pix.battleController != null && !this.dropped) {
                pix.battleController.participants.stream().filter(p -> p instanceof PlayerParticipant && p.team != this.getPixelmonWrapper().getParticipant().team).forEach(p -> {
                    this.dropNormalItems(((PlayerParticipant)p).player);
                    this.dropped = true;
                });
            }
        }
        super.func_70645_a(cause);
    }

    public void dropNormalItems(ServerPlayerEntity player) {
        if (!PixelmonConfigProxy.getGeneral().getDrops().isPokemonDropsEnabled() || this.isBossPokemon() || this.hasOwner() || this.getTrainer() != null) {
            return;
        }
        if (this.pokemon.hasNoDrops()) {
            return;
        }
        List<ItemStack> items = DropItemRegistry.getDropsForPokemon(this);
        int id = 0;
        ArrayList<DroppedItem> givenDrops = new ArrayList<DroppedItem>();
        for (ItemStack item : items) {
            if (item == null) continue;
            givenDrops.add(new DroppedItem(item, id++));
        }
        if (givenDrops.size() > 0) {
            DropItemQueryList.register(this, givenDrops, player);
        }
    }

    public void dropBossItems(ServerPlayerEntity player) {
        List<ItemStack> items = DropItemRegistry.getDropsForPokemon(this);
        if (this.pokemon.hasNoDrops()) {
            return;
        }
        int id = 0;
        ArrayList<DroppedItem> givenDrops = new ArrayList<DroppedItem>();
        for (ItemStack item : items) {
            if (item == null) continue;
            givenDrops.add(new DroppedItem(item, id++));
        }
        Set<DropSet.Drop> bossDrops = this.getBossTier().getDrops(player, this);
        for (DropSet.Drop drop : bossDrops) {
            givenDrops.add(new DroppedItem(drop, id++));
        }
        if (givenDrops.size() > 0) {
            DropItemQueryList.register(this, givenDrops, player);
        }
    }
}

