/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities;

import java.util.ArrayList;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum SpawnLocationType {
    LAND(blockPos -> new BlockPos(blockPos.func_177958_n(), 255, blockPos.func_177956_o()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.func_177977_b();
        BlockState state = world.func_180495_p(nextPos);
        while (!state.func_185904_a().func_76220_a() && !state.func_185904_a().func_76224_d()) {
            nextPos = nextPos.func_177977_b();
            state = world.func_180495_p(nextPos);
        }
        return nextPos;
    }),
    LAND_NPC(blockPos -> new BlockPos(blockPos.func_177958_n(), 255, blockPos.func_177956_o()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.func_177977_b();
        BlockState state = world.func_180495_p(nextPos);
        while (!state.func_185904_a().func_76220_a() && !state.func_185904_a().func_76224_d()) {
            nextPos = nextPos.func_177977_b();
            state = world.func_180495_p(nextPos);
        }
        return nextPos;
    }),
    LAND_VILLAGER(blockPos -> new BlockPos(blockPos.func_177958_n(), 255, blockPos.func_177956_o()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.func_177977_b();
        BlockState state = world.func_180495_p(nextPos);
        while (!state.func_185904_a().func_76220_a() && !state.func_185904_a().func_76224_d()) {
            nextPos = nextPos.func_177977_b();
            state = world.func_180495_p(nextPos);
        }
        return nextPos;
    }),
    WATER(blockPos -> new BlockPos(blockPos.func_177958_n(), 255, blockPos.func_177956_o()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.func_177977_b();
        BlockState state = world.func_180495_p(nextPos);
        while (!state.func_185904_a().func_76220_a()) {
            nextPos = nextPos.func_177977_b();
            state = world.func_180495_p(nextPos);
        }
        return nextPos;
    }),
    UNDERGROUND(blockPos -> new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() + 10, blockPos.func_177956_o()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.func_177977_b();
        BlockState normalState = world.func_180495_p(nextPos);
        BlockState aboveState = world.func_180495_p(nextPos.func_177984_a());
        while (!normalState.func_185904_a().func_76220_a() && !normalState.func_185904_a().func_76224_d() || aboveState.func_185904_a().func_76220_a()) {
            nextPos = nextPos.func_177977_b();
            aboveState = normalState;
            normalState = world.func_180495_p(nextPos);
        }
        return nextPos;
    }),
    AIR(blockPos -> blockPos, (world, blockPos) -> {
        BlockState state = world.func_180495_p(blockPos);
        while (!state.func_196958_f()) {
            blockPos = blockPos.func_177984_a();
            state = world.func_180495_p(blockPos);
        }
        return blockPos;
    }),
    AIR_PERSISTENT(blockPos -> blockPos, (world, blockPos) -> {
        BlockState state = world.func_180495_p(blockPos);
        while (!state.func_196958_f()) {
            blockPos = blockPos.func_177984_a();
            state = world.func_180495_p(blockPos);
        }
        return blockPos;
    }),
    LEGENDARY(blockPos -> blockPos, (world, blockPos) -> blockPos),
    TREE_TOP(blockPos -> blockPos, (world, blockPos) -> blockPos),
    BOSS(blockPos -> blockPos, (world, blockPos) -> blockPos);

    private final Function<BlockPos, BlockPos> spawnStartCalculator;
    private final BiFunction<World, BlockPos, BlockPos> floorCalculator;

    private SpawnLocationType(Function<BlockPos, BlockPos> spawnStartCalculator, BiFunction<World, BlockPos, BlockPos> floorCalculator) {
        this.spawnStartCalculator = spawnStartCalculator;
        this.floorCalculator = floorCalculator;
    }

    public BlockPos getSpawnLocation(World world, BlockPos xy) {
        BlockPos spawnStart = this.spawnStartCalculator.apply(xy);
        return this.floorCalculator.apply(world, spawnStart);
    }

    public static SpawnLocationType[] getSpawnLocations(ArrayList<String> list) {
        SpawnLocationType[] locations = new SpawnLocationType[list.size()];
        int i = 0;
        for (String s : list) {
            for (SpawnLocationType sp : SpawnLocationType.values()) {
                if (!sp.toString().equalsIgnoreCase(s)) continue;
                locations[i++] = sp;
            }
        }
        return locations;
    }

    public static SpawnLocationType getSpawnLocation(String location) {
        for (SpawnLocationType sp : SpawnLocationType.values()) {
            if (!sp.toString().equalsIgnoreCase(location)) continue;
            return sp;
        }
        return null;
    }

    public static SpawnLocationType getFromIndex(int integer) {
        try {
            return SpawnLocationType.values()[integer];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static SpawnLocationType nextLocation(SpawnLocationType spawnLocation) {
        switch (spawnLocation) {
            case LAND: {
                return WATER;
            }
            case AIR_PERSISTENT: {
                return LAND;
            }
        }
        return SpawnLocationType.getFromIndex((spawnLocation.ordinal() + 1) % SpawnLocationType.values().length);
    }

    public static boolean contains(SpawnLocationType[] locations, SpawnLocationType location) {
        for (SpawnLocationType l : locations) {
            if (l != location) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOnly(SpawnLocationType[] locations, SpawnLocationType location) {
        if (locations.length == 1) {
            return SpawnLocationType.contains(locations, location);
        }
        return false;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)("enum.spawnlocation." + this.toString().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
    }
}

