/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.events.battles.SpectateEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EndSpectatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetAllBattlingPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattlePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartSpectatePacket;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;

public class SpectateCommand
extends PixelCommand {
    public SpectateCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher);
    }

    @Override
    public String getName() {
        return "spectate";
    }

    @Override
    public String getUsage(CommandSource sender) {
        return "/spectate <playerName>";
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(sender);
        if (args.length == 0) {
            if (!BattleRegistry.removeSpectator(player)) {
                PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, this.getUsage(sender), new Object[0]);
            }
            NetworkHelper.sendPacket(new EndSpectatePacket(), player);
        } else if (args.length == 1) {
            ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
            if (target == player) {
                PixelmonCommandUtils.endCommand("pixelmon.command.spectate.self", new Object[0]);
            }
            if (BattleRegistry.getBattle((PlayerEntity)player) != null) {
                PixelmonCommandUtils.endCommand("pixelmon.command.general.inbattle", new Object[0]);
            }
            BattleController base = PixelmonCommandUtils.require(BattleRegistry.getBattle((PlayerEntity)target), "pixelmon.command.spectate.nobattle", target.func_145748_c_().getString());
            PlayerParticipant watchedPlayer = PixelmonCommandUtils.require(base.getPlayer(target.func_200200_C_().getString()), "command.exception", new Object[0]);
            if (!Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StartSpectate(player, base, target))) {
                if (sender.func_197022_f() != null) {
                    sender.func_197022_f().field_70144_Y = 1.0f;
                }
                NetworkHelper.sendPacket(new StartBattlePacket(base.battleIndex, base.getBattleType(watchedPlayer), base.rules), player);
                NetworkHelper.sendPacket(new SetAllBattlingPokemonPacket(PixelmonClientData.convertToGUI(Arrays.asList(watchedPlayer.allPokemon)), true), player);
                ArrayList<PixelmonWrapper> teamList = watchedPlayer.getTeamPokemonList();
                NetworkHelper.sendPacket(new SetBattlingPokemonPacket(teamList), player);
                NetworkHelper.sendPacket(new SetPokemonBattleDataPacket(PixelmonClientData.convertToGUI(teamList), false), player);
                NetworkHelper.sendPacket(new SetPokemonBattleDataPacket(watchedPlayer.getOpponentData(), true), player);
                if (base.getTeam(watchedPlayer).size() > 1) {
                    NetworkHelper.sendPacket(new SetPokemonTeamDataPacket(watchedPlayer.getAllyData()), player);
                }
                NetworkHelper.sendPacket(new StartSpectatePacket(watchedPlayer.player.func_110124_au(), base.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE)), player);
                base.addSpectator(new Spectator(player, target.func_200200_C_().getString()));
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        return args.length == 1 ? PixelmonCommandUtils.tabCompleteUsernames() : Collections.emptyList();
    }
}

