/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PokeDelCommand
extends PixelCommand {
    private static final List<String> PC_PARTY_SUGGESTION = Lists.newArrayList((Object[])new String[]{"party", "pc"});

    public PokeDelCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokedel", "Invalid usage! Usages:\n/pokedel [player] party <slot>\n/pokedel [player] party <spec...>\n/pokedel [player] pc <box> <slot>\n/pokedel [player] pc <box> <spec...>\n/pokedel [player] pc <spec...>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        boolean isParty;
        if ((args = this.setupTargetOrSourceAsTarget(sender, args, 0)).length < 3) {
            PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, this.getUsage(sender), new Object[0]);
            return;
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        if (!args[1].equalsIgnoreCase("party") && !args[1].equalsIgnoreCase("pc")) {
            PixelmonCommandUtils.endCommand("pixelmon.command.pokedel.invalidstorage", new Object[0]);
        }
        if (isParty = args[1].equalsIgnoreCase("party")) {
            this.partyDelete(sender, target, args);
        } else {
            this.compDelete(sender, target, args);
        }
    }

    private void partyDelete(CommandSource sender, ServerPlayerEntity target, String[] args) {
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        storage.retrieveAll("Command");
        if (storage.countAll() == 1) {
            sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.pokedel.lastpokemon", target.func_145748_c_().getString()));
            return;
        }
        Optional<Integer> slotOptional = NumberHelper.parseInteger(args[2]);
        if (slotOptional.isPresent()) {
            if (!PixelmonCommandUtils.PARTY_SLOTS.contains(args[2])) {
                sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.invalidslot", target.func_145748_c_().getString()));
                return;
            }
            Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slotOptional.get() - 1), "pixelmon.command.partyslot.nothing", target.func_200200_C_().getString());
            storage.set(pokemon.getPosition(), null);
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokedel.success", target.func_145748_c_().getString(), pokemon.getLocalizedName()), false);
        } else {
            String[] specList = Arrays.copyOfRange(args, 2, args.length);
            PokemonSpecification spec = PokemonSpecificationProxy.create(specList);
            for (Pokemon pokemon : storage.getTeam()) {
                if (pokemon == null || !spec.matches(pokemon)) continue;
                if (storage.countAll() == 1) {
                    sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.pokedel.lastpokemon", target.func_145748_c_().getString(), pokemon.getLocalizedName()));
                    break;
                }
                storage.set(pokemon.getPosition(), null);
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokedel.success", target.func_145748_c_().getString(), pokemon.getLocalizedName()), false);
            }
        }
    }

    private void compDelete(CommandSource sender, ServerPlayerEntity target, String[] args) {
        PCStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        storage.retrieveAll("Command");
        Optional<Integer> boxOptional = NumberHelper.parseInteger(args[2]);
        if (boxOptional.isPresent()) {
            int box = boxOptional.get();
            Optional<Integer> slotOptional = NumberHelper.parseInteger(args[3]);
            if (slotOptional.isPresent()) {
                int slot = slotOptional.get();
                Pokemon pokemon = PixelmonCommandUtils.require(storage.get(box - 1, slot - 1), "pixelmon.command.compslot.nothing", target.func_200200_C_().getString());
                storage.set(box - 1, slot - 1, null);
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokedel.success", target.func_145748_c_().getString(), pokemon.getDisplayName()), false);
            } else {
                String[] specList = Arrays.copyOfRange(args, 3, args.length);
                PokemonSpecification spec = PokemonSpecificationProxy.create(specList);
                for (Pokemon pokemon : storage.getBox(box - 1).getAll()) {
                    this.checkAndDeleteFromPC(sender, target, storage, spec, pokemon);
                }
            }
        } else {
            String[] specList = Arrays.copyOfRange(args, 2, args.length);
            PokemonSpecification spec = PokemonSpecificationProxy.create(specList);
            for (Pokemon pokemon : storage.getAll()) {
                this.checkAndDeleteFromPC(sender, target, storage, spec, pokemon);
            }
        }
    }

    private void checkAndDeleteFromPC(CommandSource sender, ServerPlayerEntity target, PCStorage storage, PokemonSpecification spec, Pokemon pokemon) {
        if (pokemon == null || !spec.matches(pokemon) || pokemon.getPosition() == null) {
            return;
        }
        storage.set(pokemon.getPosition(), null);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokedel.success", target.func_145748_c_().getString(), pokemon.getLocalizedName()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PC_PARTY_SUGGESTION;
            }
            case 2: {
                if (!hasPermissionOtherTarget) break;
                return PC_PARTY_SUGGESTION;
            }
        }
        ArrayList suggestions = Lists.newArrayList((Object[])PokemonSpecificationProxy.getRequirementNames());
        suggestions.addAll(PixelmonCommandUtils.PARTY_SLOTS);
        return suggestions;
    }
}

