/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ShopkeeperEditorScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientShopkeeperData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetShopkeeperClientPacket
extends AbstractPixelmonPacket {
    private List<ClientShopkeeperData> data = Lists.newArrayList();

    public SetShopkeeperClientPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetShopkeeperClientPacket(String language) {
        super(PacketDirection.PLAY_CLIENT);
        for (ShopkeeperData shopkeeper : ServerNPCRegistry.getEnglishShopkeepers()) {
            ArrayList names = Lists.newArrayList();
            for (int i = 0; i < shopkeeper.countNames(); ++i) {
                names.add(ServerNPCRegistry.shopkeepers.getTranslatedName(language, shopkeeper.id, i));
            }
            this.data.add(new ClientShopkeeperData(shopkeeper.id, shopkeeper.getTextures(), names));
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        ArrayHelper.encodeList(buf, this.data);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.data.clear();
        int listSize = buf.readInt();
        for (int i = 0; i < listSize; ++i) {
            this.data.add(new ClientShopkeeperData(buf));
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ShopkeeperEditorScreen.shopkeeperData = this.data;
    }
}

