/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.editor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterFactory;
import com.pixelmonmod.pixelmon.api.pokemon.export.exception.PokemonImportException;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.editor.ImportResponsePacket;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ImportRequestPacket
extends AbstractPixelmonPacket {
    private List<String> lines;

    public ImportRequestPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public ImportRequestPacket(List<String> lines) {
        this();
        this.lines = lines;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.lines.size());
        for (String line : this.lines) {
            buffer.func_180714_a(line);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int size = buffer.readInt();
        this.lines = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.lines.add(buffer.func_218666_n());
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        try {
            NetworkHelper.sendPacket(context.getSender(), new ImportResponsePacket(PokemonConverterFactory.importText(this.lines)));
        }
        catch (PokemonImportException e) {
            NetworkHelper.sendPacket(context.getSender(), new ImportResponsePacket(e.getReason(), e.getFailedValue()));
        }
    }
}

