/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.custom.drops;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.PositionTriState;
import com.pixelmonmod.pixelmon.api.events.drops.CustomDropsEvent;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CustomDropsActionPacket
extends AbstractPixelmonPacket {
    private String mnemonic;
    private PositionTriState position;
    private int index;
    private boolean closed = false;

    public CustomDropsActionPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    private CustomDropsActionPacket(String mnemonic) {
        this();
        this.mnemonic = mnemonic;
    }

    public CustomDropsActionPacket(String mnemonic, PositionTriState position) {
        this(mnemonic);
        this.position = position;
    }

    public CustomDropsActionPacket(String mnemonic, int index) {
        this(mnemonic);
        this.index = index;
    }

    public CustomDropsActionPacket(String mnemonic, boolean closed) {
        this(mnemonic);
        this.closed = closed;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.mnemonic = buf.func_218666_n();
        if (buf.readBoolean()) {
            this.position = PositionTriState.values()[buf.readByte()];
        } else {
            this.index = buf.readByte();
        }
        this.closed = buf.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.mnemonic);
        if (this.position != null) {
            buf.writeBoolean(true);
            buf.writeByte(this.position.ordinal());
        } else {
            buf.writeBoolean(false);
            buf.writeByte(this.index);
        }
        buf.writeBoolean(this.closed);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (this.closed) {
            Pixelmon.EVENT_BUS.post((Event)new CustomDropsEvent.CloseScreen(this.mnemonic, context.getSender()));
        } else if (this.position != null) {
            Pixelmon.EVENT_BUS.post((Event)new CustomDropsEvent.ClickButton(this.mnemonic, context.getSender(), this.position));
        } else {
            Pixelmon.EVENT_BUS.post((Event)new CustomDropsEvent.ClickDrop(this.mnemonic, context.getSender(), this.index));
        }
    }
}

