/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.richpresence;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.util.ThreadPool;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.util.concurrent.TimeUnit;
import net.arikia.dev.drpc.DiscordEventHandlers;
import net.arikia.dev.drpc.DiscordRPC;
import net.arikia.dev.drpc.DiscordRichPresence;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextFormatting;

public final class PixelmonRichPresence {
    public static final String LOADING_GAME = "Loading Game (%v)";
    public static final String MAIN_MENU = "Main Menu (%v)";
    public static final String SINGLEPLAYER = "Singleplayer (%v)";
    public static final String NOSERVER_DETAIL = "Catching them all!";
    public static final String SERVER_DETAIL = "Playing on %s";
    public static final String LOCAL_MULTIPLAYER = "Local Multiplayer (%v)";
    public static final String MULTIPLAYER = "Multiplayer (%v)";
    public static final String ICON_NAME = "discord.gg/pixelmon";
    private final ThreadPool THREAD_POOL = ThreadPool.createNewThreadPool("Pixelmon Rich Presence", 2);
    private final String application;
    private long time;
    private boolean available = false;
    private boolean initing = false;
    private boolean active = false;
    private boolean acknowledgedServer = false;
    private final boolean enabled = PixelmonConfigProxy.getGeneral().isUseDiscordRichPresence();

    public PixelmonRichPresence(String application) {
        this.application = application;
        this.init();
    }

    public boolean isAcknowledgedServer() {
        return this.acknowledgedServer;
    }

    public void setAcknowledgedServer(boolean acknowledgedServer) {
        this.acknowledgedServer = acknowledgedServer;
    }

    public void init() {
        if (this.enabled) {
            this.initing = true;
            DiscordRPC.discordInitialize(this.application, new DiscordEventHandlers.Builder().setReadyEventHandler(user -> {
                ClientProxy.getRichPresence().available = true;
                ClientProxy.getRichPresence().active = true;
                ClientProxy.getRichPresence().initing = false;
                Pixelmon.LOGGER.info("Discord Rich Presence ready. User " + user.userId + ".");
            }).build(), true);
            this.THREAD_POOL.scheduleAtFixedRate(this::poll, 0L, 10L);
            Runtime.getRuntime().addShutdownHook(new Thread(this::destruct));
            this.setState(LOADING_GAME);
        }
    }

    public void setState(String state) {
        this.setState(state, false);
    }

    public void setState(String state, boolean time) {
        this.setState(state, "", time, -1, -1);
    }

    public void setState(String state, String details, boolean time) {
        this.setState(state, details, time, -1, -1);
    }

    public void setState(String state, String details, boolean time, int players, int maxPlayers) {
        if (this.enabled) {
            DiscordRichPresence.Builder drp = new DiscordRichPresence.Builder(state.replace("%v", Pixelmon.getVersion())).setBigImage("main", ICON_NAME).setDetails(details.replace("%v", Pixelmon.getVersion()));
            if (time) {
                if (this.time == -1L) {
                    this.time = System.currentTimeMillis() / 1000L;
                }
                drp.setStartTimestamps(this.time);
            } else {
                this.resetTime();
            }
            if (players > -1) {
                drp.setParty(Util.field_240973_b_.toString(), players, maxPlayers);
            }
            DiscordRPC.discordUpdatePresence(drp.build());
        }
    }

    public void onJoin() {
        if (this.enabled) {
            this.resetTime();
            this.THREAD_POOL.repeatUntilComplete(this::updateGameStateRichPresence, 15L, TimeUnit.SECONDS);
        }
    }

    public void resetTime() {
        this.time = -1L;
    }

    private boolean updateGameStateRichPresence() {
        if (this.enabled) {
            IntegratedServer sp = Minecraft.func_71410_x().func_71401_C();
            ServerData mp = Minecraft.func_71410_x().func_147104_D();
            if (sp == null && mp == null) {
                return true;
            }
            if (sp != null && sp.func_71344_c() || mp != null && mp.func_181041_d()) {
                ClientProxy.getRichPresence().setState(NOSERVER_DETAIL, LOCAL_MULTIPLAYER, true, ClientStorageManager.pokedex.countCaught(), Pokedex.pokedexSize);
            } else if (sp != null && mp == null) {
                ClientProxy.getRichPresence().setState(NOSERVER_DETAIL, SINGLEPLAYER, true, ClientStorageManager.pokedex.countCaught(), Pokedex.pokedexSize);
            } else {
                int max;
                int players;
                try {
                    String status = TextFormatting.func_110646_a((String)mp.field_78846_c.getString());
                    String[] split = status.split("/");
                    players = Integer.parseInt(split[0]);
                    max = Integer.parseInt(split[1]);
                }
                catch (Exception e) {
                    players = 0;
                    max = 0;
                }
                ClientProxy.getRichPresence().setState(SERVER_DETAIL.replace("%s", mp.field_78847_a), MULTIPLAYER, true, players, max);
            }
        }
        return false;
    }

    public void poll() {
        if (this.enabled) {
            DiscordRPC.discordRunCallbacks();
        }
    }

    public void destruct() {
        if (this.enabled) {
            DiscordRPC.discordShutdown();
            this.active = false;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isIniting() {
        return this.available && this.initing;
    }
}

