/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.MenuReuseElement;
import com.pixelmonmod.pixelmon.client.gui.widgets.PixelmonWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class BattleMenuElement<B extends MenuListButton>
extends PixelmonWidget {
    protected static final ResourceLocation MENU_BACKGROUND = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_background.png");
    protected static final ResourceLocation MENU_LIST_ITEM = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_list_item.png");
    protected static final ResourceLocation MENU_LIST_LEFT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_left.png");
    protected static final ResourceLocation MENU_LIST_RIGHT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_right.png");
    private int page = 1;
    private final Screen parent;
    private ITextComponent title;
    private List<B> buttons;
    private MenuReuseElement reuseElement = null;

    public BattleMenuElement(Screen parent) {
        this.parent = parent;
        this.setTitle(StringTextComponent.field_240750_d_);
        this.setButtons(Collections.emptyList());
    }

    public BattleMenuElement(Screen parent, ITextComponent title, List<B> buttons) {
        this.parent = parent;
        this.setTitle(title);
        this.setButtons(buttons);
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public void setTitle(ITextComponent title) {
        this.title = title;
    }

    public List<B> getAllButtons() {
        return this.buttons;
    }

    public void setButtons(List<B> buttons) {
        this.buttons = buttons;
    }

    public List<B> getPageButtons() {
        ArrayList list = Lists.newArrayList();
        int maxPages = this.buttons.size() < 6 ? 1 : this.buttons.size() / 6 + (this.buttons.size() % 6 > 0 ? 1 : 0);
        int page = Math.min(this.page, maxPages);
        for (int i = 0; i < 6; ++i) {
            if (i + 6 * (page - 1) >= this.buttons.size()) continue;
            list.add(this.buttons.get(i + 6 * (page - 1)));
        }
        return list;
    }

    public void setReuseMessage(String key, @Nullable ItemStack stack) {
        this.reuseElement = key != null && !key.isEmpty() ? new MenuReuseElement(key, stack) : null;
    }

    @Override
    public void drawElement(MatrixStack matrix, float scale) {
        ScreenHelper.drawImage(matrix, MENU_BACKGROUND, (float)this.x, (float)this.y, 180.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawScaledCenteredString(matrix, this.getTitle().getString(), (float)this.x + 85.0f, this.y + 6, -986896, 14.0f);
        if (this.reuseElement != null) {
            this.reuseElement.drawElement(matrix, scale);
        }
        Minecraft mc = Minecraft.func_71410_x();
        int mouseX = (int)(mc.field_71417_B.func_198024_e() * (double)this.width / (double)this.parent.field_230708_k_);
        int mouseZ = (int)((double)this.height - mc.field_71417_B.func_198024_e() * (double)this.height / (double)this.parent.field_230709_l_ - 1.0);
        this.drawMenuButtons(matrix, mouseX, mouseZ);
    }

    @Override
    public <T extends PixelmonWidget> T setPosition(int x, int y, int width, int height) {
        Object t = super.setPosition(x, y, width, height);
        if (this.reuseElement != null) {
            this.reuseElement.setPosition(x + 45, y + height - 22, 110, 18);
        }
        for (MenuListButton button : this.getAllButtons()) {
            button.setPosition(x, y, width, height);
        }
        return t;
    }

    public void drawMenuButtons(MatrixStack matrix, int mouseX, int mouseY) {
        int maxPages = this.buttons.size() < 6 ? 1 : this.buttons.size() / 6 + (this.buttons.size() % 6 > 0 ? 1 : 0);
        this.page = Math.min(this.page, maxPages);
        for (int i = 0; i < 6; ++i) {
            if (i + 6 * (this.page - 1) >= this.buttons.size()) continue;
            ((MenuListButton)((Object)this.buttons.get(i + 6 * (this.page - 1)))).func_230431_b_(matrix, mouseX, mouseY, 0.0f);
        }
        if (maxPages > 1) {
            ScreenHelper.drawScaledCenteredString(matrix, this.page + "/" + maxPages, 85.0f, this.y + this.height - 38, -986896, 14.0f);
            if (this.page < maxPages) {
                ScreenHelper.drawImage(matrix, MENU_LIST_RIGHT, 100.0f, (float)(this.y + this.height - 39), 8.0f, 8.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (this.page > 1) {
                ScreenHelper.drawImage(matrix, MENU_LIST_LEFT, 62.0f, (float)(this.y + this.height - 39), 8.0f, 8.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }

    public boolean isOverReturnButton(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + 30) && mouseY >= (double)(this.y + this.height - 30) && mouseY < (double)(this.y + this.height);
    }

    public boolean isOverReuseButton(double mouseX, double mouseY) {
        return this.reuseElement != null && this.reuseElement.isMouseOver(mouseX, mouseY);
    }

    public boolean handleClickPageTurn(double mouseX, double mouseY) {
        int maxPages;
        int n = this.buttons.size() < 6 ? 1 : (maxPages = this.buttons.size() / 6 + (this.buttons.size() % 6 > 0 ? 1 : 0));
        if (maxPages > 1) {
            if (this.page > 1 && mouseX >= 62.0 && mouseY >= (double)(this.y + this.height - 39) && mouseX < 70.0 && mouseY < (double)(this.y + this.height - 39 + 8)) {
                --this.page;
                return true;
            }
            if (this.page < maxPages && mouseX >= 100.0 && mouseY >= (double)(this.y + this.height - 39) && mouseX < 108.0 && mouseY < (double)(this.y + this.height - 39 + 8)) {
                ++this.page;
                return true;
            }
        }
        return false;
    }

    public static class MenuListButton
    extends Button {
        private boolean isPressed;
        public int id;

        public MenuListButton(int id, Screen parent) {
            super(0, 0, parent.field_230708_k_, parent.field_230709_l_, StringTextComponent.field_240750_d_, action -> {});
            this.id = id;
            this.setPosition(0, 0, parent.field_230708_k_, parent.field_230709_l_);
        }

        public <T extends MenuListButton> T setPosition(int x, int y, int width, int height) {
            this.field_230690_l_ = x + 5;
            this.field_230691_m_ = y + 20 + this.id % 6 * 30;
            this.field_230688_j_ = 155;
            this.field_230689_k_ = 26;
            return (T)((Object)this);
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                ScreenHelper.drawImage(matrix, MENU_LIST_ITEM, (float)this.field_230690_l_, (float)this.field_230691_m_, (float)this.field_230688_j_, (float)this.field_230689_k_, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            this.isPressed = super.func_231044_a_(mouseX, mouseY, button);
            return this.isPressed;
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            this.isPressed = false;
            return true;
        }
    }
}

