/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class HealerTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int TICKS_TO_PLACE = 5;
    private static final int TICKS_TO_HEAL = 100;
    private UUID owner = null;
    public boolean beingUsed = false;
    public PokeBall[] pokeballType = new PokeBall[6];
    private PlayerPartyStorage storage;
    public PlayerEntity player;
    private int pokemonLastPlaced = -1;
    private float healingRate = 1.0f;
    private int tickCount = 0;
    public float rotation = 0.0f;
    public int flashTimer = 0;
    public boolean allPlaced = false;
    public boolean playSound = false;
    public boolean stayDark = false;

    public HealerTileEntity() {
        super((TileEntityType)TileEntityRegistration.HEALER.get());
    }

    public void use(NPCNurseJoy npc, PlayerEntity player) {
        this.startHealing(player, 2.0f, npc.getTextureIndex());
    }

    public void use(PlayerEntity player) {
        this.startHealing(player, 1.0f, 0);
    }

    private void startHealing(PlayerEntity player, float healingRate, int textureIndex) {
        this.healingRate = healingRate;
        this.storage = StorageProxy.getParty((ServerPlayerEntity)player);
        this.storage.teleportPos.store((RegistryKey<World>)player.func_130014_f_().func_234923_W_(), player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
        this.player = player;
        this.beingUsed = true;
        if (healingRate == 2.0f) {
            OpenScreenPacket.open(player, EnumGuiScreen.HealerNurseJoy, textureIndex);
        } else {
            OpenScreenPacket.open(player, EnumGuiScreen.Healer, new int[0]);
        }
        this.tickCount = 0;
        this.allPlaced = false;
        this.pokemonLastPlaced = -1;
        for (int i = 0; i < this.pokeballType.length; ++i) {
            this.pokeballType[i] = null;
        }
        this.stayDark = false;
        if (!this.field_145850_b.field_72995_K && this.beingUsed) {
            this.sendRedstoneSignal();
        }
    }

    public void setColor(DyeColor dyeColor) {
        this.field_145850_b.func_180501_a(this.func_174877_v(), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("pixelmon", dyeColor.name().toLowerCase(Locale.ROOT) + "_healer"))).func_176223_P(), 3);
    }

    private int getTicksToHeal() {
        return (int)(100.0f / this.healingRate);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.rotation += 19.0f;
            ++this.flashTimer;
            return;
        }
        if (this.beingUsed) {
            int ticksToHeal;
            if (this.allPlaced && !this.playSound) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)SoundRegistration.HEALER_ACTIVATE.get(), SoundCategory.BLOCKS, 0.7f, 1.0f);
                this.playSound = true;
            }
            ++this.tickCount;
            if (!this.allPlaced && this.tickCount == 5) {
                boolean hasNextPokemon = false;
                this.storage.retrieveAll("BlockInteract");
                for (int i = this.pokemonLastPlaced + 1; i < this.storage.getTeam().size(); ++i) {
                    if (this.storage.getTeam().get(i) == null) continue;
                    this.pokemonLastPlaced = i;
                    hasNextPokemon = true;
                    this.pokeballType[i] = this.storage.getTeam().get(i).getBall();
                    break;
                }
                if (!hasNextPokemon) {
                    this.allPlaced = true;
                }
                this.tickCount = 0;
                this.refreshTexture();
            }
            if (this.tickCount == (ticksToHeal = this.getTicksToHeal()) - 30) {
                this.stayDark = true;
                this.refreshTexture();
            }
            if (this.tickCount == ticksToHeal) {
                this.storage.getTeam().forEach(Pokemon::heal);
                this.beingUsed = false;
                this.playSound = false;
                this.refreshTexture();
                this.player.func_71053_j();
                if (!this.field_145850_b.field_72995_K) {
                    this.sendRedstoneSignal();
                }
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("owner")) {
            this.owner = UUID.fromString(compound.func_74779_i("owner"));
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = this.func_189515_b(new CompoundNBT());
        for (int i = 0; i < this.pokeballType.length; ++i) {
            if (this.pokeballType[i] == null) continue;
            nbt.func_74778_a("PokeballType" + i, this.pokeballType[i].getName());
        }
        nbt.func_74757_a("BeingUsed", this.beingUsed);
        nbt.func_74757_a("AllPlaced", this.allPlaced);
        nbt.func_74757_a("StayDark", this.stayDark);
        nbt.func_74776_a("HealRate", this.healingRate);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
        for (int i = 0; i < this.pokeballType.length; ++i) {
            this.pokeballType[i] = null;
            if (!compound.func_74764_b("PokeballType" + i)) continue;
            this.pokeballType[i] = PokeBallRegistry.getPokeBall(compound.func_74779_i("PokeballType" + i)).orElse((PokeBall)null);
        }
        if (compound.func_74764_b("BeingUsed")) {
            this.beingUsed = compound.func_74767_n("BeingUsed");
            this.allPlaced = compound.func_74767_n("AllPlaced");
            this.stayDark = compound.func_74767_n("StayDark");
        }
        if (compound.func_74764_b("HealRate")) {
            this.healingRate = compound.func_74760_g("HealRate");
        }
    }

    private void sendRedstoneSignal() {
        Block block = this.func_195044_w().func_177230_c();
        this.field_145850_b.func_195593_d(this.field_174879_c, block);
    }

    private void refreshTexture() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
            this.func_70296_d();
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isBeingUsed() {
        return this.beingUsed;
    }

    public PokeBall[] getPokeballType() {
        return this.pokeballType;
    }

    public PlayerPartyStorage getStorage() {
        return this.storage;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public int getPokemonLastPlaced() {
        return this.pokemonLastPlaced;
    }

    public float getHealingRate() {
        return this.healingRate;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public float getRotation() {
        return this.rotation;
    }

    public int getFlashTimer() {
        return this.flashTimer;
    }

    public boolean isAllPlaced() {
        return this.allPlaced;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public boolean isStayDark() {
        return this.stayDark;
    }
}

