/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.legendary.ArceusEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.blocks.ArcChaliceBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.enums.EnumPlate;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.ArrayUtils;

public class ArcChaliceTileEntity
extends TileEntity
implements ITickableTileEntity {
    public List<Integer> platesIn = Lists.newArrayList();
    public short animationTimer = 0;
    public boolean animating = false;
    public byte plateAdded = (byte)-1;
    public boolean itemThere = false;
    private ItemEntity spawnedItem = null;
    private transient UUID lastUsedPlayer = null;

    public ArcChaliceTileEntity() {
        super((TileEntityType)TileEntityRegistration.ARC_CHALICE.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74783_a("Plates", ArrayUtils.toPrimitive((Integer[])this.platesIn.toArray(new Integer[0])));
        nbt.func_74777_a("AnimationTimer", this.animationTimer);
        nbt.func_74757_a("Animating", this.animating);
        nbt.func_74774_a("CurrentPlate", this.plateAdded);
        nbt.func_74757_a("ItemThere", this.itemThere);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        ArrayList platesRead = Lists.newArrayList();
        for (int i : nbt.func_74759_k("Plates")) {
            platesRead.add(i);
        }
        this.platesIn = platesRead;
        this.animationTimer = nbt.func_74765_d("AnimationTimer");
        this.animating = nbt.func_74767_n("Animating");
        this.plateAdded = nbt.func_74771_c("CurrentPlate");
        this.itemThere = nbt.func_74767_n("ItemThere");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tagCompound = new CompoundNBT();
        this.func_189515_b(tagCompound);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void activate(PlayerEntity player, ArcChaliceBlock block, BlockState state, ItemStack item) {
        EnumPlate plate;
        if (!this.field_145850_b.field_72995_K && (plate = EnumPlate.getPlateForItem(item.func_77973_b())) != null) {
            if (!this.platesIn.contains(plate.ordinal()) && this.plateAdded != plate.ordinal()) {
                if (Pixelmon.EVENT_BUS.post((Event)new ArceusEvent.AddPlate((ServerPlayerEntity)player, this, item))) {
                    return;
                }
                if (this.plateAdded != -1) {
                    this.platesIn.add(Integer.valueOf(this.plateAdded));
                }
                item.func_190918_g(1);
                this.plateAdded = (byte)plate.ordinal();
                this.animationTimer = 0;
                this.animating = true;
                this.lastUsedPlayer = player.func_110124_au();
                this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundEvents.field_187618_I, SoundCategory.BLOCKS, 0.6f, 0.75f);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.plate.add", EnumPlate.values().length - this.platesIn.size() - 1);
                this.func_70296_d();
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.plate.fail", new Object[0]);
            }
        }
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        super.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.spawnedItem != null && !this.spawnedItem.func_70089_S() && this.itemThere || this.spawnedItem == null && this.itemThere) {
                this.spawnedItem = null;
                this.itemThere = false;
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.func_70296_d();
            }
            if (this.animating) {
                this.animationTimer = (short)(this.animationTimer + 1);
                if (this.platesIn.size() >= 17) {
                    if (this.animationTimer > 500) {
                        this.platesIn.clear();
                        this.plateAdded = (byte)-1;
                        this.animating = false;
                        this.animationTimer = 0;
                        ItemStack azureFlute = new ItemStack((IItemProvider)PixelmonItems.azure_flute, 1);
                        ItemEntity item = new ItemEntity(this.func_145831_w(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, azureFlute);
                        item.func_189654_d(true);
                        item.func_213293_j(0.0, 0.0, 0.0);
                        Pixelmon.EVENT_BUS.post((Event)new ArceusEvent.CreateFlute(this.lastUsedPlayer, this, item));
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.25, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 0.5f, 1.0E-4f);
                        this.field_145850_b.func_217376_c((Entity)item);
                        this.spawnedItem = item;
                        this.itemThere = true;
                    }
                } else if (this.animationTimer > 100) {
                    this.platesIn.add(Integer.valueOf(this.plateAdded));
                    this.plateAdded = (byte)-1;
                    this.animating = false;
                    this.animationTimer = 0;
                }
                this.func_70296_d();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

