/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Splinters
extends StatusBase {
    transient PixelmonWrapper user;
    transient int turnsToGo;

    public Splinters() {
        super(StatusType.Splinters);
    }

    public Splinters(PixelmonWrapper user, int turnsToGo) {
        super(StatusType.Splinters);
        this.user = user;
        this.turnsToGo = turnsToGo;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(StatusType.Splinters)) {
            return;
        }
        if (target.addStatus(new Splinters(target, 3), target)) {
            user.bc.sendToAll("pixelmon.effect.splinters", target.getNickname());
            return;
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        Ability victimAbility = pw.getBattleAbility();
        if (victimAbility instanceof MagicGuard) {
            return;
        }
        pw.bc.sendToAll("pixelmon.status.splintersdamage", pw.getNickname());
        pw.doBattleDamage(this.user, 25.0f, DamageTypeEnum.ATTACK);
        if (--this.turnsToGo <= 0) {
            pw.bc.sendToAll("pixelmon.status.splinterscleared", pw.getNickname());
            pw.removeStatus(this);
            return;
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (target.getBattleAbility() instanceof MagicGuard) {
                userChoice.raiseWeight(22.0f);
                continue;
            }
            userChoice.raiseWeight(35.0f);
        }
    }
}

