/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.GaleWings;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Mimicry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Prankster;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Triage;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Drain;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Purify;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Recover;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Rest;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.ShoreUp;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.StrengthSap;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Swallow;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Synthesis;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.HealingWish;
import com.pixelmonmod.pixelmon.battles.status.LunarDance;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Wish;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class PsychicTerrain
extends Terrain {
    public PsychicTerrain(boolean extended) {
        super(StatusType.PsychicTerrain, "pixelmon.status.psychicterrain", "pixelmon.status.psychicterrainend", extended);
    }

    public PsychicTerrain(int turnsToGo) {
        super(StatusType.PsychicTerrain, turnsToGo, "pixelmon.status.psychicterrain", "pixelmon.status.psychicterrainend");
    }

    @Override
    public Terrain getNewInstance() {
        return new PsychicTerrain(false);
    }

    @Override
    @Nonnull
    public com.pixelmonmod.pixelmon.api.battles.Terrain getTerrainType() {
        return com.pixelmonmod.pixelmon.api.battles.Terrain.PSYCHIC;
    }

    @Override
    public Element getTypingForTerrain() {
        return Element.PSYCHIC;
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        if (this.affectsPokemon(pokemon) && Math.round(user.priority) > 0) {
            if (user.attack.isAttack(AttackRegistry.PERISH_SONG, AttackRegistry.FLOWER_SHIELD, AttackRegistry.ROTOTILLER, AttackRegistry.PURSUIT)) {
                return false;
            }
            if (user.attack.getMove().getTargetingInfo().hitsAll || user.attack.isAttack(EntryHazard.ENTRY_HAZARDS)) {
                return false;
            }
            boolean targetsOwnTeam = true;
            for (PixelmonWrapper target : user.targets) {
                if (!user.isOpponent(target)) continue;
                targetsOwnTeam = false;
            }
            if (targetsOwnTeam) {
                return false;
            }
            user.bc.sendToAll("pixelmon.battletext.movefailed", new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.affectsPokemon(user) && a.getType() == Element.PSYCHIC) {
            power = (int)((double)power * 1.3);
        }
        return new int[]{power, accuracy};
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        if (this.affectsPokemon(target)) {
            Attack a;
            if (Attack.hasOffensiveAttackType(user.getMoveset(), Element.PSYCHIC)) {
                ++benefits;
            }
            Iterator iterator = target.getMoveset().iterator();
            while (iterator.hasNext() && (a = (Attack)iterator.next()) != null) {
                if (a.getMove().getPriority(target) > 0 || a.getAttackCategory() == AttackCategory.STATUS && target.getAbility() instanceof Prankster || a.getType().equals(Element.FLYING) && target.getAbility() instanceof GaleWings) {
                    --benefits;
                }
                if (a.isAttack(AttackRegistry.NATURE_POWER) || a.isAttack(AttackRegistry.SECRET_POWER) || a.isAttack(AttackRegistry.CAMOUFLAGE) || a.isAttack(AttackRegistry.EXPANDING_FORCE) || a.isAttack(AttackRegistry.TERRAIN_PULSE)) {
                    ++benefits;
                }
                if (!target.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Triage.class)) continue;
                for (EffectBase effect : a.getMove().effects) {
                    if (!(effect instanceof Recover) && !(effect instanceof Drain) && !(effect instanceof Rest) && !(effect instanceof Synthesis) && !(effect instanceof HealingWish) && !(effect instanceof LunarDance) && !(effect instanceof Purify) && !(effect instanceof ShoreUp) && !(effect instanceof StrengthSap) && !(effect instanceof Swallow) && !(effect instanceof Wish)) continue;
                    --benefits;
                }
            }
            if (target.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Mimicry.class)) {
                ++benefits;
            }
            if (target.hasHeldItem() && target.getHeldItem().getHeldItemType() == EnumHeldItems.terrainExtender || target.getHeldItem().getHeldItemType() == EnumHeldItems.terrainSeed) {
                ++benefits;
            }
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new PsychicTerrain(this.turnsToGo);
    }
}

