/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.List;

public class PowerTrick
extends StatusBase {
    public PowerTrick() {
        super(StatusType.PowerTrick);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        user.bc.sendToAll("pixelmon.status.powertrick", user.getNickname());
        if (!user.removeStatus(this.type)) {
            user.addStatus(new PowerTrick(), user);
        }
    }

    @Override
    public int[] modifyBaseStats(PixelmonWrapper user, int[] stats) {
        int temp = stats[BattleStatsType.ATTACK.getStatIndex()];
        stats[BattleStatsType.ATTACK.getStatIndex()] = stats[BattleStatsType.DEFENSE.getStatIndex()];
        stats[BattleStatsType.DEFENSE.getStatIndex()] = temp;
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        StatusBase prevStatus = pw.getStatus(this.type);
        ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
        BattleAIBase ai = pw.getBattleAI();
        try {
            pw.bc.simulateMode = false;
            pw.bc.sendMessages = false;
            this.applyEffect(pw, pw);
            pw.bc.simulateMode = true;
            pw.bc.modifyStats();
            pw.bc.modifyStatsCancellable(pw);
            List<MoveChoice> bestUserChoicesAfter = ai.getBestAttackChoices(pw);
            List<List<MoveChoice>> bestOpponentChoicesAfter = ai.getBestAttackChoices(opponents);
            ai.weightFromUserOptions(pw, userChoice, bestUserChoices, bestUserChoicesAfter);
            ai.weightFromOpponentOptions(pw, userChoice, MoveChoice.splitChoices(opponents, bestOpponentChoices), bestOpponentChoicesAfter);
        }
        finally {
            pw.bc.simulateMode = false;
            pw.removeStatus(this.type);
            if (prevStatus != null) {
                pw.addStatus(prevStatus, pw);
            }
            pw.bc.simulateMode = true;
            pw.bc.sendMessages = true;
            pw.bc.modifyStats();
            pw.bc.modifyStatsCancellable(pw);
        }
    }
}

