/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Rollout
extends MultiTurnSpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        int turnCount;
        if (!this.doesPersist(user)) {
            this.setPersists(user, true);
            this.setTurnCount(user, 5);
        }
        if ((turnCount = this.getTurnCount(user)) == 0) {
            turnCount = 5;
        }
        user.attack.setOverridePower(30 << 5 - turnCount);
        if (user.hasStatus(StatusType.DefenseCurl)) {
            user.attack.setOverridePower(user.attack.getMove().getBasePower() * 2);
        }
        this.decrementTurnCount(user);
        if (this.getTurnCount(user) <= 0) {
            this.setPersists(user, false);
        }
        return AttackResult.proceed;
    }

    @Override
    public void removeEffect(PixelmonWrapper user, PixelmonWrapper target) {
        this.setPersists(user, false);
    }

    @Override
    public boolean shouldNotLosePP(PixelmonWrapper user) {
        return this.getTurnCount(user) < 4;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.tier >= 3) {
            userChoice.weight /= 2.0f;
        }
    }
}

