/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;

public class TextHelper {
    private static final String REGEX = "(&([a-f0-9k-r]))";
    private static final Pattern PATTERN = Pattern.compile("(&([a-f0-9k-r]))", 2);
    private static final Pattern COLOUR_PATTERN = Pattern.compile("&(#\\w{6}|[\\da-zA-Z])");
    public static final List<String> DENY_CHARS = Lists.newArrayList((Object[])new String[]{"%"});
    public static final Pattern DENY_PATTERN = Pattern.compile("[&\u00a7][0-9a-fk-orA-FK-OR]");
    public static final int NAME_MAX_LENGTH = 16;
    public static final IFormattableTextComponent OR_DELIMITER = new TranslationTextComponent("pixelmon.text.delimiter.or");
    public static final IFormattableTextComponent AND_DELIMITER = new TranslationTextComponent("pixelmon.text.delimiter.and");

    public static ITextComponent colour(String text) {
        Matcher matcher = COLOUR_PATTERN.matcher(text);
        StringTextComponent textComponent = new StringTextComponent("");
        TextFormatting nextApply = null;
        int lastEnd = 0;
        Color lastColor = null;
        while (matcher.find()) {
            int start = matcher.start();
            String segment = text.substring(lastEnd, start);
            IFormattableTextComponent iFormattableTextComponent = TextHelper.attemptAppend((IFormattableTextComponent)textComponent, segment, lastColor);
            if (nextApply != null && iFormattableTextComponent != null) {
                iFormattableTextComponent.func_240699_a_(nextApply);
            }
            lastEnd = matcher.end();
            String colourCode = matcher.group(1);
            Optional<Color> colour = TextHelper.parseColour(colourCode);
            if (colour.isPresent()) {
                lastColor = colour.get();
                nextApply = null;
                continue;
            }
            TextFormatting byCode = TextHelper.getByCode(colourCode.toCharArray()[0]);
            if (byCode != null) {
                nextApply = byCode;
                continue;
            }
            textComponent.func_230529_a_((ITextComponent)new StringTextComponent("&" + colourCode));
        }
        String segment = text.substring(lastEnd);
        IFormattableTextComponent iFormattableTextComponent = TextHelper.attemptAppend((IFormattableTextComponent)textComponent, segment, lastColor);
        if (nextApply != null && iFormattableTextComponent != null) {
            iFormattableTextComponent.func_240699_a_(nextApply);
        }
        return textComponent;
    }

    public static IFormattableTextComponent attemptAppend(IFormattableTextComponent textComponent, String segment, Color lastColour) {
        if (segment.isEmpty()) {
            return null;
        }
        StringTextComponent appended = new StringTextComponent(segment);
        if (lastColour != null) {
            appended.func_230530_a_(Style.field_240709_b_.func_240718_a_(lastColour));
        }
        textComponent.func_230529_a_((ITextComponent)appended);
        return appended;
    }

    public static Optional<Color> parseColour(String colourCode) {
        Color colour = Color.func_240745_a_((String)colourCode);
        if (colour != null) {
            return Optional.of(colour);
        }
        if (colourCode.length() > 1) {
            return Optional.empty();
        }
        TextFormatting byCode = TextHelper.getByCode(colourCode.toCharArray()[0]);
        if (byCode == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Color.func_240744_a_((TextFormatting)byCode));
    }

    public static TextFormatting getByCode(char p_211165_0_) {
        char c0 = Character.toString(p_211165_0_).toLowerCase(Locale.ROOT).charAt(0);
        switch (c0) {
            case '0': {
                return TextFormatting.BLACK;
            }
            case '1': {
                return TextFormatting.DARK_BLUE;
            }
            case '2': {
                return TextFormatting.DARK_GREEN;
            }
            case '3': {
                return TextFormatting.DARK_AQUA;
            }
            case '4': {
                return TextFormatting.DARK_RED;
            }
            case '5': {
                return TextFormatting.DARK_PURPLE;
            }
            case '6': {
                return TextFormatting.GOLD;
            }
            case '7': {
                return TextFormatting.GRAY;
            }
            case '8': {
                return TextFormatting.DARK_GRAY;
            }
            case '9': {
                return TextFormatting.BLUE;
            }
            case 'a': {
                return TextFormatting.GREEN;
            }
            case 'b': {
                return TextFormatting.AQUA;
            }
            case 'c': {
                return TextFormatting.RED;
            }
            case 'd': {
                return TextFormatting.LIGHT_PURPLE;
            }
            case 'e': {
                return TextFormatting.YELLOW;
            }
            case 'f': {
                return TextFormatting.WHITE;
            }
            case 'k': {
                return TextFormatting.OBFUSCATED;
            }
            case 'l': {
                return TextFormatting.BOLD;
            }
            case 'm': {
                return TextFormatting.STRIKETHROUGH;
            }
            case 'n': {
                return TextFormatting.UNDERLINE;
            }
            case 'o': {
                return TextFormatting.ITALIC;
            }
            case 'r': {
                return TextFormatting.RESET;
            }
        }
        return null;
    }

    public static ITextComponent format(String in, Object ... args) {
        for (int i = args.length; i > 0; --i) {
            in = in.replace("%" + i, String.valueOf(args[i - 1]));
        }
        return TextHelper.colour(in);
    }

    public static ITextComponent combine(Object ... components) {
        StringTextComponent component = new StringTextComponent("");
        for (Object object : components) {
            if (object instanceof ITextComponent) {
                component.func_230529_a_((ITextComponent)object);
                continue;
            }
            component.func_240702_b_(String.valueOf(object));
        }
        return component;
    }

    public static String format(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (matcher.find()) {
            line = line.replaceAll(REGEX, "\u00a7$2");
        }
        return line;
    }

    public static IFormattableTextComponent translate(TextFormatting colour, String text, Object ... args) {
        return new TranslationTextComponent(text, args).func_240699_a_(colour);
    }

    public static IFormattableTextComponent translate(String text, Object ... args) {
        return new TranslationTextComponent(text, args);
    }

    public static IFormattableTextComponent translate(TextFormatting colour, String text) {
        return TextHelper.translate(colour, text, new Object[0]);
    }

    public static TranslationTextComponent translate(String text) {
        return new TranslationTextComponent(text);
    }

    public static IFormattableTextComponent color(final TextFormatting colour, String str) {
        return new StringTextComponent(str){
            {
                super(x0);
                this.func_240699_a_(colour);
            }
        };
    }

    public static IFormattableTextComponent textWithShowTextHover(String str, String hover) {
        return TextHelper.textWithShowTextHover((IFormattableTextComponent)new StringTextComponent(str), (IFormattableTextComponent)new StringTextComponent(hover));
    }

    public static IFormattableTextComponent textWithShowTextHover(String str, IFormattableTextComponent hover) {
        return TextHelper.textWithShowTextHover((IFormattableTextComponent)new StringTextComponent(str), hover);
    }

    public static IFormattableTextComponent textWithShowTextHover(IFormattableTextComponent str, String hover) {
        return TextHelper.textWithShowTextHover(str, (IFormattableTextComponent)new StringTextComponent(hover));
    }

    public static IFormattableTextComponent textWithShowTextHover(IFormattableTextComponent text, IFormattableTextComponent hover) {
        return text.func_230530_a_(text.func_150256_b().func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)hover)));
    }

    public static IFormattableTextComponent join(List<ITextComponent> texts, ITextComponent delimiter) {
        StringTextComponent result = new StringTextComponent("");
        for (int i = 0; i < texts.size(); ++i) {
            boolean isLast;
            result = result.func_230529_a_(texts.get(i));
            boolean bl = isLast = texts.size() - 1 == i;
            if (isLast) continue;
            result = result.func_230529_a_(delimiter);
        }
        return result;
    }

    public static IFormattableTextComponent joinStrings(List<String> texts, IFormattableTextComponent delimiter) {
        StringTextComponent result = new StringTextComponent("");
        for (int i = 0; i < texts.size(); ++i) {
            boolean isLast;
            result = result.func_230529_a_((ITextComponent)new StringTextComponent(texts.get(i)));
            boolean bl = isLast = texts.size() - 1 == i;
            if (isLast) continue;
            result = result.func_230529_a_((ITextComponent)delimiter);
        }
        return result;
    }

    public static IFormattableTextComponent space(int spaces) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            str.append(" ");
        }
        return new StringTextComponent(str.toString());
    }
}

