/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.Validate;

public class BufferHelper {
    public static int varIntByteCount(int toCount) {
        return (toCount & 0xFFFFFF80) == 0 ? 1 : ((toCount & 0xFFFFC000) == 0 ? 2 : ((toCount & 0xFFE00000) == 0 ? 3 : ((toCount & 0xF0000000) == 0 ? 4 : 5)));
    }

    public static int readVarInt(PacketBuffer buf, int maxSize) {
        byte b0;
        Validate.isTrue((maxSize < 6 && maxSize > 0 ? 1 : 0) != 0, (String)"Varint length is between 1 and 5, not %d", (long)maxSize);
        int i = 0;
        int j = 0;
        do {
            b0 = buf.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= maxSize) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static void writeVarInt(ByteBuf to, int toWrite, int maxSize) {
        Validate.isTrue((BufferHelper.varIntByteCount(toWrite) <= maxSize ? 1 : 0) != 0, (String)"Integer is too big for %d bytes", (long)maxSize);
        while ((toWrite & 0xFFFFFF80) != 0) {
            to.writeByte(toWrite & 0x7F | 0x80);
            toWrite >>>= 7;
        }
        to.writeByte(toWrite);
    }
}

