/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.GymSignTileEntity;
import java.util.ConcurrentModificationException;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.StructureVoidBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class PixelBlockSnapshot {
    public static final String PIXEL_SNAPSHOT_BLOCK_NAME = "blockName";
    public final BlockPos pos;
    public transient BlockState replacedBlock;
    private final CompoundNBT nbt;
    public transient World world;
    public final ResourceLocation blockIdentifier;

    public static PixelBlockSnapshot readFromNBT(World newWorld, CompoundNBT tag) {
        CompoundNBT nbt = tag.func_74767_n("hasTE") ? tag.func_74775_l("tileEntity") : null;
        PixelBlockSnapshot snap = new PixelBlockSnapshot(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")), tag.func_74764_b("blockMod") ? tag.func_74779_i("blockMod") : "minecraft", tag.func_74779_i(PIXEL_SNAPSHOT_BLOCK_NAME), nbt);
        snap.world = newWorld;
        return snap;
    }

    public PixelBlockSnapshot(World world, BlockPos pos, BlockState state) {
        this.world = world;
        this.pos = pos;
        this.replacedBlock = state;
        this.blockIdentifier = state.func_177230_c().getRegistryName();
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            this.nbt = new CompoundNBT();
            te.func_189515_b(this.nbt);
        } else {
            this.nbt = null;
        }
    }

    public PixelBlockSnapshot(World world, BlockPos pos, BlockState state, CompoundNBT nbt) {
        this.world = world;
        this.pos = pos;
        this.replacedBlock = state;
        this.blockIdentifier = state.func_177230_c().getRegistryName();
        this.nbt = nbt;
    }

    public PixelBlockSnapshot(BlockPos pos, String modid, String blockName, CompoundNBT nbt) {
        this.pos = pos;
        this.blockIdentifier = ResourceLocationHelper.of(modid, blockName);
        this.nbt = nbt;
    }

    public PixelBlockSnapshot(BlockPos pos, BlockState state, CompoundNBT nbt) {
        this.pos = pos;
        this.blockIdentifier = state.func_177230_c().getRegistryName();
        this.nbt = nbt;
    }

    public static PixelBlockSnapshot getBlockSnapshot(World world, BlockPos pos) {
        return new PixelBlockSnapshot(world, pos, world.func_180495_p(pos));
    }

    public static PixelBlockSnapshot readFromNBT(CompoundNBT tag) {
        CompoundNBT nbt = tag.func_74767_n("hasTE") ? null : tag.func_74775_l("tileEntity");
        return new PixelBlockSnapshot(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")), tag.func_74764_b("blockMod") ? tag.func_74779_i("blockMod") : "minecraft", tag.func_74779_i(PIXEL_SNAPSHOT_BLOCK_NAME), nbt);
    }

    public BlockState getCurrentBlock() {
        return this.world.func_180495_p(this.pos);
    }

    public TileEntity getTileEntity() {
        if (this.nbt != null) {
            return TileEntity.func_235657_b_((BlockState)this.getCurrentBlock(), (CompoundNBT)this.nbt);
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        Block replacedBlock;
        BlockState current = this.getCurrentBlock();
        BlockState replaced = this.getReplacedBlock();
        Block currentBlock = current.func_177230_c();
        if (currentBlock != (replacedBlock = replaced.func_177230_c())) {
            if (force) {
                this.world.func_180501_a(this.pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.world.func_180501_a(this.pos, replaced, applyPhysics ? 3 : 2);
        this.world.func_184138_a(this.pos, current, replaced, applyPhysics ? 3 : 2);
        TileEntity te = null;
        if (this.nbt != null && (te = this.world.func_175625_s(this.pos)) != null) {
            te.deserializeNBT(this.nbt);
        }
        return true;
    }

    public boolean restoreToLocation(World world, BlockPos pos, boolean force, boolean applyPhysics) {
        BlockState current = this.getCurrentBlock();
        BlockState replaced = this.getReplacedBlock();
        if (current.func_177230_c() != replaced.func_177230_c()) {
            if (force) {
                world.func_180501_a(pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.func_180501_a(pos, replaced, applyPhysics ? 3 : 2);
        world.func_184138_a(pos, current, replaced, applyPhysics ? 3 : 2);
        TileEntity te = null;
        if (this.nbt != null && (te = world.func_175625_s(pos)) != null) {
            te.deserializeNBT(this.nbt);
        }
        return true;
    }

    public void writeToNBT(CompoundNBT compound) {
        if (!this.blockIdentifier.func_110624_b().equals("minecraft")) {
            compound.func_74778_a("blockMod", this.blockIdentifier.func_110624_b());
        }
        compound.func_74778_a(PIXEL_SNAPSHOT_BLOCK_NAME, this.blockIdentifier.func_110624_b());
        compound.func_74768_a("x", this.pos.func_177958_n());
        compound.func_74768_a("y", this.pos.func_177956_o());
        compound.func_74768_a("z", this.pos.func_177952_p());
        compound.func_74757_a("hasTE", this.nbt != null);
        if (this.nbt != null) {
            compound.func_218657_a("tileEntity", (INBT)this.nbt);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PixelBlockSnapshot other = (PixelBlockSnapshot)obj;
        if (!this.pos.equals((Object)other.pos)) {
            return false;
        }
        if (!(this.nbt == other.nbt || this.nbt != null && this.nbt.equals((Object)other.nbt))) {
            return false;
        }
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        return this.blockIdentifier == other.blockIdentifier || this.blockIdentifier != null && this.blockIdentifier.equals((Object)other.blockIdentifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.pos.func_177958_n();
        hash = 73 * hash + this.pos.func_177956_o();
        hash = 73 * hash + this.pos.func_177952_p();
        hash = 73 * hash + (this.nbt != null ? this.nbt.hashCode() : 0);
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + (this.blockIdentifier != null ? this.blockIdentifier.hashCode() : 0);
        return hash;
    }

    public BlockState getReplacedBlock() {
        if (this.replacedBlock == null) {
            IForgeRegistry blockRegistry = GameRegistry.findRegistry(Block.class);
            try {
                this.replacedBlock = ((Block)blockRegistry.getValue(this.blockIdentifier)).func_176223_P();
            }
            catch (Exception e) {
                System.out.println("Cannot find Block " + this.blockIdentifier.func_110624_b() + ": " + this.blockIdentifier.func_110623_a());
            }
        }
        return this.replacedBlock;
    }

    public void restoreToLocationWithRotation(BlockPos pos, Direction facing, int yLevel, boolean recreateTechnicalBlocks) {
        this.restoreToLocationWithRotation(pos, facing, yLevel, recreateTechnicalBlocks, null);
    }

    public void restoreToLocationWithRotation(BlockPos pos, Direction facing, int yLevel, boolean recreateTechnicalBlocks, ItemStack replacement) {
        TileEntity te;
        BlockState replaced = this.getReplacedBlock();
        replaced = this.checkOrientation(replaced, facing);
        if (!recreateTechnicalBlocks && replaced.func_177230_c() instanceof StructureVoidBlock) {
            return;
        }
        try {
            if (replaced.func_177230_c() instanceof DoorBlock) {
                if (replaced.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER) {
                    DoorBlock.func_196263_a((BlockState)this.getCurrentBlock(), (BlockState)replaced, (IWorld)this.world, (BlockPos)pos, (int)3);
                }
            } else if (replaced.func_177230_c() instanceof BedBlock) {
                if (replaced.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.FOOT) {
                    int color = this.nbt == null ? 0 : this.nbt.func_74762_e("color");
                    BlockHelper.placeBed(this.world, pos, (Direction)replaced.func_177229_b((Property)BedBlock.field_185512_D), DyeColor.func_196056_a((int)color));
                }
            } else {
                this.world.func_180501_a(pos, replaced, 3);
            }
        }
        catch (ConcurrentModificationException e) {
            return;
        }
        this.world.func_184138_a(pos, replaced, replaced, 2);
        if (yLevel == 0) {
            BlockPos posDown;
            BlockState blockDown;
            for (int toCheck = pos.func_177956_o() - 1; toCheck > 0 && ((blockDown = this.world.func_180495_p(posDown = new BlockPos(pos.func_177958_n(), toCheck, pos.func_177952_p()))).func_177230_c() instanceof AirBlock || blockDown.func_177230_c() instanceof FlowingFluidBlock); --toCheck) {
                try {
                    this.world.func_180501_a(posDown, replaced, 3);
                }
                catch (ConcurrentModificationException e) {
                    return;
                }
                this.world.func_184138_a(posDown, replaced, replaced, 2);
            }
        }
        if (replaced.func_177230_c() instanceof LeverBlock) {
            Direction[] aenumfacing;
            for (Direction enumfacing : aenumfacing = Direction.values()) {
                this.world.func_195593_d(pos.func_177972_a(enumfacing), replaced.func_177230_c());
            }
        }
        if (this.nbt != null && (te = this.world.func_175625_s(pos)) != null) {
            this.nbt.func_74768_a("x", pos.func_177958_n());
            this.nbt.func_74768_a("y", pos.func_177956_o());
            this.nbt.func_74768_a("z", pos.func_177952_p());
            te.deserializeNBT(this.nbt);
            ((ServerWorld)this.world).func_72863_F().func_217217_a(pos);
            if (te instanceof GymSignTileEntity) {
                ((GymSignTileEntity)te).setDroppable(false);
                if (replacement != null) {
                    ((GymSignTileEntity)te).setItemInSign(replacement);
                }
            }
        }
    }

    private BlockState checkOrientation(BlockState replaced, Direction facing) {
        if (facing != Direction.EAST) {
            if (replaced.func_235901_b_((Property)LeverBlock.field_185512_D)) {
                Direction orientation = (Direction)replaced.func_177229_b((Property)LeverBlock.field_185512_D);
                if (orientation == Direction.DOWN) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        orientation = Direction.UP;
                    }
                } else if (orientation == Direction.DOWN) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        orientation = Direction.UP;
                    }
                } else if (orientation == Direction.UP) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        orientation = Direction.DOWN;
                    }
                } else if (orientation == Direction.DOWN) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        orientation = Direction.UP;
                    }
                } else if (facing == Direction.SOUTH) {
                    if (orientation == Direction.EAST) {
                        orientation = Direction.SOUTH;
                    } else if (orientation == Direction.SOUTH) {
                        orientation = Direction.WEST;
                    } else if (orientation == Direction.WEST) {
                        orientation = Direction.NORTH;
                    } else if (orientation == Direction.NORTH) {
                        orientation = Direction.EAST;
                    }
                } else if (facing == Direction.WEST) {
                    if (orientation == Direction.EAST) {
                        orientation = Direction.WEST;
                    } else if (orientation == Direction.SOUTH) {
                        orientation = Direction.NORTH;
                    } else if (orientation == Direction.WEST) {
                        orientation = Direction.EAST;
                    } else if (orientation == Direction.NORTH) {
                        orientation = Direction.SOUTH;
                    }
                } else if (facing == Direction.NORTH) {
                    if (orientation == Direction.EAST) {
                        orientation = Direction.NORTH;
                    } else if (orientation == Direction.SOUTH) {
                        orientation = Direction.EAST;
                    } else if (orientation == Direction.WEST) {
                        orientation = Direction.SOUTH;
                    } else if (orientation == Direction.NORTH) {
                        orientation = Direction.WEST;
                    }
                }
                replaced = (BlockState)replaced.func_206870_a((Property)LeverBlock.field_185512_D, (Comparable)orientation);
            } else if (replaced.func_177230_c() instanceof StandingSignBlock) {
                int rotation = (Integer)replaced.func_177229_b((Property)StandingSignBlock.field_176413_a);
                if (facing == Direction.WEST) {
                    rotation += 8;
                } else if (facing == Direction.SOUTH) {
                    rotation += 4;
                } else if (facing == Direction.NORTH) {
                    rotation += 12;
                }
                if (rotation > 15) {
                    rotation -= 16;
                }
                replaced = (BlockState)replaced.func_206870_a((Property)StandingSignBlock.field_176413_a, (Comparable)Integer.valueOf(rotation));
            } else if (replaced.func_177230_c() == Blocks.field_150395_bd) {
                boolean east = false;
                boolean west = false;
                boolean south = false;
                boolean north = false;
                if (facing == Direction.WEST) {
                    east = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176280_O);
                    west = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176278_M);
                    north = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176279_N);
                    south = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176273_b);
                } else if (facing == Direction.SOUTH) {
                    east = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176273_b);
                    west = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176279_N);
                    north = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176280_O);
                    south = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176278_M);
                } else if (facing == Direction.NORTH) {
                    east = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176279_N);
                    west = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176273_b);
                    north = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176278_M);
                    south = (Boolean)replaced.func_177229_b((Property)VineBlock.field_176280_O);
                }
                replaced = (BlockState)((BlockState)((BlockState)((BlockState)replaced.func_206870_a((Property)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)VineBlock.field_176280_O, (Comparable)Boolean.valueOf(west))).func_206870_a((Property)VineBlock.field_176279_N, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)VineBlock.field_176273_b, (Comparable)Boolean.valueOf(north));
            } else {
                for (Property property : replaced.func_235904_r_()) {
                    DirectionProperty directionProperty;
                    Direction orientation;
                    if (!(property instanceof DirectionProperty) || (orientation = (Direction)replaced.func_177229_b((Property)(directionProperty = (DirectionProperty)property))) == Direction.UP || orientation == Direction.DOWN) continue;
                    if (facing == Direction.WEST) {
                        replaced = (BlockState)replaced.func_206870_a((Property)directionProperty, (Comparable)orientation.func_176746_e().func_176746_e());
                        continue;
                    }
                    if (facing == Direction.NORTH) {
                        replaced = (BlockState)replaced.func_206870_a((Property)directionProperty, (Comparable)orientation.func_176735_f());
                        continue;
                    }
                    if (facing != Direction.SOUTH) continue;
                    replaced = (BlockState)replaced.func_206870_a((Property)directionProperty, (Comparable)orientation.func_176746_e());
                }
            }
        }
        return replaced;
    }
}

