/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.notexamples;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.status.MysteriousAirCurrent;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NonExtremeWeatherFailsDuringDeltaStreamTest {
    private NonExtremeWeatherFailsDuringDeltaStreamTest() {
        throw new UnsupportedOperationException("Unit test");
    }

    @UnitTest(value="non_extreme_weather_fails_during_delta_stream")
    public static CompletableFuture<TestResult> testNonExtremeWeatherFailsDuringDeltaStream() {
        Attack dragonAscent = AttackRegistry.DRAGON_ASCENT.get().ofMutable();
        Attack protect = AttackRegistry.PROTECT.get().ofMutable();
        Attack sunnyDay = AttackRegistry.SUNNY_DAY.get().ofMutable();
        WildPixelmonParticipant rayquaza = NonExtremeWeatherFailsDuringDeltaStreamTest.createRayquaza(dragonAscent);
        WildPixelmonParticipant castform = NonExtremeWeatherFailsDuringDeltaStreamTest.createCastform();
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Mega)).teamOne(rayquaza).teamTwo(castform).start().thenCompose(controller -> {
            System.out.println("Starting test for non-extreme weather failing to replace Delta Stream's weather.");
            rayquaza.asWrapper().setAttack(protect, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{rayquaza.asWrapper()}), true);
            castform.asWrapper().setAttack(sunnyDay, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{castform.asWrapper()}), false);
            rayquaza.asWrapper().bc.updateTurnZero();
            rayquaza.asWrapper().takeTurn();
            castform.asWrapper().takeTurn();
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            System.out.println("Finishing test for non-extreme weather failing to replace Delta Stream's weather.");
            if (rayquaza.asWrapper().bc.globalStatusController.getWeather() instanceof MysteriousAirCurrent) {
                return TestResult.success();
            }
            return TestResult.failure("The weather Rayquaza created was replaced by a non-extreme weather.");
        });
    }

    private static WildPixelmonParticipant createRayquaza(Attack ... attacks) {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.RAYQUAZA.getValue()).moves(attacks).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }

    private static WildPixelmonParticipant createCastform() {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.CASTFORM.getValue()).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }
}

