/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.example;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class SplashTest {
    private SplashTest() {
        throw new UnsupportedOperationException("Unit test");
    }

    @UnitTest(value="splash_no_damage")
    public static CompletableFuture<TestResult> testSplashDealsNoDamage() {
        Attack splash = AttackRegistry.SPLASH.get().ofMutable();
        WildPixelmonParticipant magikarpOne = SplashTest.createMagikarpWithOnlySplash(splash);
        WildPixelmonParticipant magikarpTwo = SplashTest.createMagikarpWithOnlySplash(splash);
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(magikarpOne).teamTwo(magikarpTwo).start().thenCompose(controller -> {
            magikarpOne.asWrapper().setAttack(splash, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{magikarpTwo.asWrapper()}), false);
            magikarpOne.asWrapper().useAttack();
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            if ((double)magikarpOne.asWrapper().getHealthPercent() == 100.0 && (double)magikarpTwo.asWrapper().getHealthPercent() == 100.0) {
                return TestResult.success();
            }
            return TestResult.failure("Splash effect dealt damage");
        });
    }

    private static WildPixelmonParticipant createMagikarpWithOnlySplash(Attack ... attacks) {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.MAGIKARP.getValue()).moves(attacks).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }

    @UnitTest(value="example")
    public static CompletableFuture<TestResult> example(int runs) {
        ArrayList testResults = Lists.newArrayList();
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < runs; ++i) {
            futures.add(SplashTest.testSplashDealsNoDamage().thenApply(testResults::add));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(unused -> {
            for (TestResult testResult : testResults) {
                if (testResult.isSuccess()) continue;
                return TestResult.failure("One of them failued");
            }
            return TestResult.success();
        });
    }
}

