/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.gender;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class GenderProperties {
    private final Gender gender;
    private final PaletteProperties[] palettes;

    public GenderProperties(Gender gender, PaletteProperties[] palettes) {
        this.gender = gender;
        this.palettes = palettes;
    }

    public Gender getGender() {
        return this.gender;
    }

    public PaletteProperties[] getPalettes() {
        return this.palettes;
    }

    public List<PaletteProperties> getPalettes(Predicate<PaletteProperties> predicate) {
        ArrayList palettes = Lists.newArrayList();
        for (PaletteProperties value : this.palettes) {
            if (!predicate.test(value)) continue;
            palettes.add(value);
        }
        return palettes;
    }

    public PaletteProperties getPalette(String name) {
        for (PaletteProperties palette : this.palettes) {
            if (!palette.getName().equalsIgnoreCase(name)) continue;
            return palette;
        }
        return null;
    }

    public PaletteProperties getDefaultPalette() {
        PaletteProperties palette = this.getPalette("none");
        if (palette != null) {
            return palette;
        }
        return this.palettes[0];
    }

    public boolean isDefaultPalette(PaletteProperties palette) {
        return Objects.equals(this.getDefaultPalette(), palette);
    }
}

