/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.aggression;

import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class AggressionChances {
    private final int timid;
    private final int passive;
    private final int aggressive;

    public AggressionChances(int timid, int passive, int aggressive) {
        this.timid = timid;
        this.passive = passive;
        this.aggressive = aggressive;
    }

    public AggressionChances(int timid, int aggressive) {
        this(timid, 100 - (timid + aggressive), aggressive);
    }

    public Aggression calculateAggression() {
        return this.calculateAggression(null);
    }

    public Aggression calculateAggression(UUID owner) {
        if (owner != null) {
            return Aggression.PASSIVE;
        }
        int random = ThreadLocalRandom.current().nextInt(100) + 1;
        if (random < this.timid) {
            return Aggression.TIMID;
        }
        if (random < this.passive) {
            return Aggression.PASSIVE;
        }
        if (random < this.aggressive) {
            return Aggression.AGGRESSIVE;
        }
        return Aggression.PASSIVE;
    }

    public int getTimid() {
        return this.timid;
    }

    public int getPassive() {
        return this.passive;
    }

    public int getAggressive() {
        return this.aggressive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggressionChances)) {
            return false;
        }
        AggressionChances that = (AggressionChances)o;
        return this.getTimid() == that.getTimid() && this.getPassive() == that.getPassive() && this.getAggressive() == that.getAggressive();
    }

    public int hashCode() {
        return Objects.hash(this.getTimid(), this.getPassive(), this.getAggressive());
    }
}

