/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.raids;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.init.registry.RaidRegistry;
import java.util.List;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class RegisterRaidEvent
extends Event {
    protected final RaidRegistry.RaidStarGrouping grouping;

    protected RegisterRaidEvent(RaidRegistry.RaidStarGrouping grouping) {
        this.grouping = grouping;
    }

    @Cancelable
    public static class AddDefault
    extends RegisterRaidEvent {
        private int stars;
        private RaidRegistry.Raid raid;

        public AddDefault(RaidRegistry.RaidStarGrouping grouping, int stars, RaidRegistry.Raid raid) {
            super(grouping);
            this.stars = stars;
            this.raid = raid;
        }

        public int getStars() {
            return this.stars;
        }

        public RaidRegistry.Raid getRaid() {
            return this.raid;
        }

        public void setRaid(int stars, Species species) {
            this.setRaid(stars, species, null);
        }

        public void setRaid(int stars, Species species, Stats form) {
            if (stars >= 1 && stars <= 5) {
                this.stars = stars;
                this.raid = new RaidRegistry.Raid(species.getDex(), form.getName());
            } else {
                Pixelmon.LOGGER.warn("RegisterRaidEvent.AddDefault: cannot set raid star pokemonLevel below 1 or above 5!");
                this.setCanceled(true);
            }
        }
    }

    public static class Register
    extends RegisterRaidEvent {
        private boolean defaults = true;

        public Register(RaidRegistry.RaidStarGrouping grouping) {
            super(grouping);
        }

        public void enableDefaults() {
            this.defaults = true;
        }

        public void disableDefaults() {
            this.defaults = false;
        }

        public boolean shouldUseDefaults() {
            return this.defaults;
        }

        public void clearRaids() {
            for (List<RaidRegistry.Raid> inner : this.grouping.getGroupings().values()) {
                inner.clear();
            }
        }

        public void addRaid(int stars, Species species) {
            this.addRaid(stars, species, null);
        }

        public void addRaid(int stars, Species species, Stats form) {
            if (stars >= 1 && stars <= 5) {
                this.grouping.addRaid(stars, species.getDex(), form.getName());
            } else {
                Pixelmon.LOGGER.warn("RegisterRaidEvent.Register: cannot set raid star pokemonLevel below 1 or above 5!");
            }
        }
    }
}

