/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.dialogue;

import com.pixelmonmod.pixelmon.api.dialogue.Choice;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.DialogueNextActionPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.eventbus.api.Event;

public class DialogueChoiceEvent
extends Event {
    public final ServerPlayerEntity player;
    public final Choice choice;
    private DialogueNextActionPacket.DialogueGuiAction action;
    private ArrayList<Dialogue> newDialogues = new ArrayList();

    public DialogueChoiceEvent(ServerPlayerEntity player, Choice choice) {
        this.player = player;
        this.choice = choice;
        this.action = DialogueNextActionPacket.DialogueGuiAction.CONTINUE;
    }

    public DialogueNextActionPacket.DialogueGuiAction getAction() {
        return this.action;
    }

    public void setAction(DialogueNextActionPacket.DialogueGuiAction action) {
        if (action != null) {
            this.action = action;
        }
    }

    public DialogueChoiceEvent addDialogue(Dialogue newDialogue) {
        if (newDialogue != null) {
            this.newDialogues.add(newDialogue);
        }
        return this;
    }

    public void setNewDialogues(ArrayList<Dialogue> newDialogues) {
        if (newDialogues != null) {
            this.newDialogues = newDialogues;
        }
    }

    public ArrayList<Dialogue> getNewDialogues() {
        return this.newDialogues;
    }

    public void reply(Dialogue ... dialogues) {
        this.reply(false, dialogues);
    }

    public void reply(boolean insert, Dialogue ... dialogues) {
        this.action = insert ? DialogueNextActionPacket.DialogueGuiAction.INSERT_DIALOGUES : DialogueNextActionPacket.DialogueGuiAction.NEW_DIALOGUES;
        HashMap<Integer, Consumer<DialogueChoiceEvent>> choiceMap = new HashMap<Integer, Consumer<DialogueChoiceEvent>>();
        for (Dialogue dialogue : dialogues) {
            for (Choice choice : dialogue.choices) {
                choiceMap.put(choice.choiceID, choice.handle);
            }
            this.addDialogue(dialogue);
        }
        Choice.handleMap.put(this.player.func_110124_au(), choiceMap);
    }

    public void reply(String name, String ... texts) {
        for (String text : texts) {
            this.addDialogue(Dialogue.builder().setName(name).setText(text).build());
        }
    }
}

