/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.advancements.triggers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class SpecTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = ResourceLocationHelper.of("pixelmon:spec_trigger");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        this.listeners.computeIfAbsent(playerAdvancementsIn, ___ -> new Listeners(playerAdvancementsIn)).add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners spectrigger$Listeners = this.listeners.get(playerAdvancementsIn);
        if (spectrigger$Listeners != null) {
            spectrigger$Listeners.remove(listener);
            if (spectrigger$Listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, ConditionArrayParser conditions) {
        String specJson = json.has("spec") ? JSONUtils.func_151200_h((JsonObject)json, (String)"spec") : "";
        PokemonSpecification spec = PokemonSpecificationProxy.create(specJson);
        return new Instance(this.func_192163_a(), spec);
    }

    public void trigger(ServerPlayerEntity player, Pokemon pokemon) {
        Listeners spectrigger$Listeners = this.listeners.get(player.func_192039_O());
        if (spectrigger$Listeners != null) {
            spectrigger$Listeners.trigger(pokemon);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Pokemon pokemon) {
            ArrayList list = Lists.newArrayList(this.listeners);
            if (list.isEmpty()) {
                return;
            }
            for (ICriterionTrigger.Listener listener : list) {
                if (!((Instance)listener.func_192158_a()).test(pokemon)) continue;
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final PokemonSpecification spec;

        public Instance(ResourceLocation criterionIn, PokemonSpecification spec) {
            super(criterionIn, EntityPredicate.AndPredicate.field_234582_a_);
            this.spec = spec;
        }

        public boolean test(Pokemon pokemon) {
            return pokemon != null && this.spec.matches(pokemon);
        }
    }
}

