/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.advancements.triggers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class LegendaryCaptureTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = ResourceLocationHelper.of("pixelmon:legendary_capture_trigger");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements player, ICriterionTrigger.Listener<Instance> listener) {
        this.listeners.computeIfAbsent(player, ___ -> new Listeners(player)).add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners internalListeners = this.listeners.get(playerAdvancementsIn);
        if (internalListeners != null) {
            internalListeners.remove(listener);
            if (internalListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, ConditionArrayParser conditions) {
        String pokemon = json.has("pokemon") ? JSONUtils.func_151200_h((JsonObject)json, (String)"pokemon") : "";
        return new Instance(this.func_192163_a(), () -> {
            RegistryValue<Species> species = PixelmonSpecies.fromName(pokemon);
            if (!species.isInitialized()) {
                Pixelmon.LOGGER.error("There was an error in Legendary Advancement trigger: " + pokemon + " " + this.func_192163_a());
                Pixelmon.LOGGER.error(json.toString());
                return null;
            }
            return species.getValueUnsafe();
        }, pokemon);
    }

    public void trigger(ServerPlayerEntity player, Pokemon pokemon) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(pokemon);
        }
    }

    private static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Pokemon pokemon) {
            ArrayList list = Lists.newArrayList();
            list.addAll(this.listeners);
            if (list.isEmpty()) {
                return;
            }
            for (ICriterionTrigger.Listener listener : list) {
                if (!((Instance)listener.func_192158_a()).test(pokemon)) continue;
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final String name;
        private final Supplier<Species> pokemon;

        public Instance(ResourceLocation criterionIn, Supplier<Species> pokemon, String name) {
            super(criterionIn, EntityPredicate.AndPredicate.field_234582_a_);
            this.pokemon = pokemon;
            this.name = name;
        }

        public boolean test(Pokemon pokemon) {
            if (pokemon == null || !pokemon.isLegendary()) {
                return false;
            }
            if (this.name.equalsIgnoreCase("legendary")) {
                return true;
            }
            Species species = this.pokemon.get();
            return species != null && species.is(pokemon.getSpecies());
        }
    }
}

