/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.advancements.triggers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class BallCaptureTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = ResourceLocationHelper.of("pixelmon:ball_capture_trigger");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners ballcapturetrigger$Listeners = this.listeners.get(playerAdvancementsIn);
        if (ballcapturetrigger$Listeners == null) {
            ballcapturetrigger$Listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, ballcapturetrigger$Listeners);
        }
        ballcapturetrigger$Listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners BallCaptureTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (BallCaptureTrigger$listeners != null) {
            BallCaptureTrigger$listeners.remove(listener);
            if (BallCaptureTrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, ConditionArrayParser conditions) {
        String pokeball = json.has("pokeball") ? JSONUtils.func_151200_h((JsonObject)json, (String)"pokeball") : "";
        Supplier<PokeBall> ball = () -> PokeBallRegistry.getPokeBall(pokeball).orElse((PokeBall)null);
        return new Instance(this.func_192163_a(), ball);
    }

    public void trigger(ServerPlayerEntity player, PokeBall pokeball) {
        Listeners ballcapturetrigger$Listeners = this.listeners.get(player.func_192039_O());
        if (ballcapturetrigger$Listeners != null) {
            ballcapturetrigger$Listeners.trigger(pokeball);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(PokeBall pokeball) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    if (!((Instance)listener.func_192158_a()).test(pokeball)) continue;
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final Supplier<PokeBall> pokeball;

        public Instance(ResourceLocation criterionIn, Supplier<PokeBall> pokeball) {
            super(criterionIn, EntityPredicate.AndPredicate.field_234582_a_);
            this.pokeball = pokeball;
        }

        public boolean test(PokeBall pokeball) {
            return this.pokeball.get().is(pokeball);
        }
    }
}

