/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.Heightmap;

public class TeleportAwayGoal
extends Goal {
    PixelmonEntity pixelmon;
    Random rand;

    public TeleportAwayGoal(PixelmonEntity entity) {
        this.pixelmon = entity;
        this.rand = entity.func_70681_au();
    }

    public boolean func_75250_a() {
        return !this.pixelmon.hasOwner() && this.pixelmon.field_70170_p.func_217362_a((Entity)this.pixelmon, 7.0) != null;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        TeleportAwayGoal.teleportRandomly(this.pixelmon, this.rand);
    }

    public static boolean teleportRandomly(PixelmonEntity pixelmon, Random rand) {
        return TeleportAwayGoal.teleportTo(pixelmon, rand, pixelmon.func_226277_ct_() + (rand.nextDouble() - 0.5) * 64.0, 256.0, pixelmon.func_226281_cx_() + (rand.nextDouble() - 0.5) * 64.0);
    }

    protected static boolean teleportTo(PixelmonEntity pixelmon, Random rand, double suggestedXPos, double suggestedYPos, double suggestedZPos) {
        double currentXPos = pixelmon.func_226277_ct_();
        double currentYPos = pixelmon.func_226278_cu_();
        double currentZPos = pixelmon.func_226281_cx_();
        int intPosX = MathHelper.func_76128_c((double)suggestedXPos);
        int intPosY = MathHelper.func_76128_c((double)suggestedYPos);
        int intPosZ = MathHelper.func_76128_c((double)suggestedZPos);
        BlockPos newLocation = pixelmon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(intPosX, intPosY, intPosZ));
        intPosY = newLocation.func_177956_o();
        if (pixelmon.field_70170_p.isAreaLoaded(newLocation, 1)) {
            pixelmon.func_70107_b(intPosX, intPosY, intPosZ);
            pixelmon.func_70107_b(pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_());
            TeleportAwayGoal.createEndermanEffect(pixelmon, rand, currentXPos, currentYPos, currentZPos);
            if (pixelmon.field_70170_p.func_226666_b_((Entity)pixelmon, pixelmon.func_174813_aQ()).count() != 0L || pixelmon.field_70170_p.func_72953_d(pixelmon.func_174813_aQ())) {
                return false;
            }
        }
        return true;
    }

    private static void createEndermanEffect(PixelmonEntity pixelmon, Random rand, double currentXPos, double currentYPos, double currentZPos) {
        int baseArea = 128;
        for (int variance = 0; variance < baseArea; ++variance) {
            double bounding = (double)variance / ((double)baseArea - 1.0);
            float floatRandX = (rand.nextFloat() - 0.5f) * 0.2f;
            float floatRandY = (rand.nextFloat() - 0.5f) * 0.2f;
            float floatRandZ = (rand.nextFloat() - 0.5f) * 0.2f;
            double doubleRandX = currentXPos + (pixelmon.func_226277_ct_() - currentXPos) * bounding + (rand.nextDouble() - 0.5) * (double)pixelmon.func_213311_cf() * 2.0;
            double doubleRandY = currentYPos + (pixelmon.func_226278_cu_() - currentYPos) * bounding + rand.nextDouble() * (double)pixelmon.func_213302_cg();
            double doubleRandZ = currentZPos + (pixelmon.func_226281_cx_() - currentZPos) * bounding + (rand.nextDouble() - 0.5) * pixelmon.getForm().getDimensions().getLength() * 2.0;
            pixelmon.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, doubleRandX, doubleRandY, doubleRandZ, (double)floatRandX, (double)floatRandY, (double)floatRandZ);
        }
        pixelmon.field_70170_p.func_184148_a(null, currentXPos, currentYPos, currentZPos, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }
}

