/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.AggressionEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.init.registry.EffectRegistration;
import com.pixelmonmod.pixelmon.listener.RepelHandler;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.eventbus.api.Event;

public abstract class TargetGoal
extends Goal {
    protected CreatureEntity taskOwner;
    protected float targetDistance;
    protected boolean shouldCheckSight;
    private boolean mustReach;
    private int reachCache = 0;
    private int reachCacheTime = 0;
    private int unseenTicks = 0;

    public TargetGoal(PixelmonEntity par1EntityLiving, float par2, boolean par3) {
        this((CreatureEntity)par1EntityLiving, par2, par3, false);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public TargetGoal(CreatureEntity entity, float par2, boolean par3, boolean par4) {
        this.taskOwner = entity;
        this.targetDistance = par2;
        this.shouldCheckSight = par3;
        this.mustReach = par4;
    }

    public boolean func_75253_b() {
        LivingEntity target;
        if (this.taskOwner instanceof PixelmonEntity) {
            PixelmonEntity pokemon = (PixelmonEntity)this.taskOwner;
            if (pokemon.battleController != null || pokemon.getBossTier().isBoss()) {
                return false;
            }
        } else if (((NPCTrainer)this.taskOwner).battleController != null) {
            return false;
        }
        if ((target = this.taskOwner.func_70638_az()) instanceof ServerPlayerEntity) {
            if (((PlayerEntity)target).func_184812_l_() || target.func_175149_v()) {
                return false;
            }
            return EvolutionQueryList.get((PlayerEntity)((ServerPlayerEntity)target)) == null;
        }
        if (target == null || !target.func_70089_S() || this.taskOwner.func_70068_e((Entity)target) > (double)(this.targetDistance * this.targetDistance)) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.taskOwner instanceof NPCTrainer) {
                if (this.taskOwner.func_70635_at().func_75522_a((Entity)target) && this.checkAngle(target)) {
                    this.unseenTicks = 0;
                } else if (++this.unseenTicks > 60) {
                    return false;
                }
            } else if (this.taskOwner.func_70635_at().func_75522_a((Entity)target)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > 60) {
                return false;
            }
        }
        return true;
    }

    private boolean checkAngle(LivingEntity var1) {
        double B;
        Vector3d look = this.taskOwner.func_70676_i(1.0f);
        Vector3d toTarget = new Vector3d(this.taskOwner.func_226277_ct_() - var1.func_226277_ct_(), this.taskOwner.func_226278_cu_() - var1.func_226278_cu_(), this.taskOwner.func_226281_cx_() - var1.func_226281_cx_());
        double top = look.field_72450_a * toTarget.field_72450_a + look.field_72448_b * toTarget.field_72448_b + look.field_72449_c * toTarget.field_72449_c;
        double A = Math.sqrt(Math.pow(look.field_72450_a, 2.0) + Math.pow(look.field_72448_b, 2.0) + Math.pow(look.field_72449_c, 2.0));
        double angle = Math.acos(top / (A * (B = Math.sqrt(Math.pow(toTarget.field_72450_a, 2.0) + Math.pow(toTarget.field_72448_b, 2.0) + Math.pow(toTarget.field_72449_c, 2.0)))));
        return Math.abs(angle - Math.PI) <= 0.2;
    }

    public void func_75249_e() {
        this.reachCache = 0;
        this.reachCacheTime = 0;
        this.unseenTicks = 0;
    }

    public void func_75251_c() {
        this.taskOwner.func_70624_b(null);
    }

    public void func_75246_d() {
        if (this.taskOwner.func_70638_az() instanceof PlayerEntity && this.taskOwner.func_70638_az().func_70644_a((Effect)EffectRegistration.AVOIDANCE.get())) {
            this.func_75251_c();
        }
    }

    protected boolean isSuitableTarget(LivingEntity entity, boolean targetInvulnerable) {
        if (entity == null || !(entity instanceof PixelmonEntity) && !(entity instanceof PlayerEntity) || entity == this.taskOwner || !entity.func_70089_S() || entity.func_70644_a((Effect)EffectRegistration.AVOIDANCE.get())) {
            return false;
        }
        if (entity instanceof PlayerEntity && this.taskOwner instanceof NPCTrainer) {
            NPCTrainer trainer = (NPCTrainer)this.taskOwner;
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack heldItem = player.func_184614_ca();
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() == PixelmonItems.trainer_editor && trainer.getAIMode().doesEngage() || !trainer.canStartBattle(player, false)) {
                return false;
            }
        }
        LivingEntity thisOwner = null;
        if (this.taskOwner instanceof PixelmonEntity) {
            thisOwner = ((PixelmonEntity)this.taskOwner).getOwner();
        }
        if (thisOwner != null) {
            PixelmonEntity targetPokemon;
            if (entity instanceof PixelmonEntity && ((targetPokemon = (PixelmonEntity)entity).getOwner() == thisOwner || targetPokemon.spawner != null)) {
                return false;
            }
            if (entity == ((TameableEntity)this.taskOwner).func_70902_q()) {
                return false;
            }
        } else {
            if (entity instanceof PlayerEntity && !targetInvulnerable && ((PlayerEntity)entity).field_71075_bZ.field_75102_a) {
                return false;
            }
            if (entity instanceof ServerPlayerEntity) {
                int highestLevel;
                PlayerPartyStorage storage = StorageProxy.getParty((ServerPlayerEntity)entity);
                if (storage.countAblePokemon() < 1) {
                    return false;
                }
                if (RepelHandler.hasRepel((ServerPlayerEntity)entity) && this.taskOwner instanceof PixelmonEntity && (highestLevel = storage.getHighestLevel()) > ((PixelmonEntity)this.taskOwner).getLvl().getPokemonLevel()) {
                    return false;
                }
                if (Pixelmon.EVENT_BUS.post((Event)new AggressionEvent((MobEntity)this.taskOwner, (ServerPlayerEntity)entity))) {
                    return false;
                }
            }
        }
        if (this.shouldCheckSight && !this.taskOwner.func_70635_at().func_75522_a((Entity)entity)) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                int n = this.reachCache = this.canReach(entity) ? 1 : 2;
            }
            if (this.reachCache == 2) {
                return false;
            }
        }
        if (entity instanceof ServerPlayerEntity) {
            if (((PlayerEntity)entity).func_184812_l_() || entity.func_175149_v()) {
                this.func_75251_c();
                return false;
            }
            return EvolutionQueryList.get((PlayerEntity)((ServerPlayerEntity)entity)) == null;
        }
        return true;
    }

    private boolean canReach(LivingEntity par1EntityLiving) {
        int var5;
        this.reachCacheTime = 10 + this.taskOwner.func_70681_au().nextInt(5);
        Path var2 = this.taskOwner.func_70661_as().func_75494_a((Entity)par1EntityLiving, 0);
        if (var2 == null) {
            return false;
        }
        PathPoint var3 = var2.func_75870_c();
        if (var3 == null) {
            return false;
        }
        int var4 = var3.field_75839_a - MathHelper.func_76128_c((double)par1EntityLiving.func_226277_ct_());
        return (double)(var4 * var4 + (var5 = var3.field_75839_a - MathHelper.func_76128_c((double)par1EntityLiving.func_226281_cx_())) * var5) <= 2.25;
    }
}

