/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class SwimmingGoal
extends Goal {
    private PixelmonEntity pixelmon;
    private float swimSpeed = 1.5f;
    private float decayRate = 0.99f;
    private int depthRangeStart = 0;
    private int depthRangeEnd = 100;
    private float moveSpeed;
    private int ticksToRefresh;
    private double delta = 0.0;
    private boolean shouldSink = false;
    boolean lastChangeDirection;
    boolean useLastChangeDirection;

    public SwimmingGoal(PixelmonEntity entity) {
        this.pixelmon = entity;
        if (entity.getSwimmingParameters() != null) {
            this.swimSpeed = entity.getSwimmingParameters().getSwimSpeed();
            this.decayRate = entity.getSwimmingParameters().getDecayRate();
            this.depthRangeStart = entity.getSwimmingParameters().getDepthRangeStart();
            this.depthRangeEnd = entity.getSwimmingParameters().getDepthRangeEnd();
            this.ticksToRefresh = entity.getSwimmingParameters().getRefreshRate();
            this.shouldSink = entity.getSwimmingParameters().isShouldSink();
        }
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        return this.pixelmon.func_70090_H() && this.pixelmon.battleController == null;
    }

    public void func_75246_d() {
        if (this.shouldSink || this.depthRangeStart == -1) {
            this.pixelmon.func_213317_d(new Vector3d(0.0, -0.01, 0.0));
            return;
        }
        boolean useLastChangeDirection = false;
        BlockRayTraceResult mop = this.pixelmon.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.pixelmon.func_226277_ct_(), this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.func_226281_cx_()), new Vector3d(this.pixelmon.func_226277_ct_() + this.pixelmon.func_70040_Z().field_72450_a * 5.0, this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.func_226281_cx_() + this.pixelmon.func_70040_Z().field_72449_c * 5.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.pixelmon));
        if (mop.func_216346_c() == RayTraceResult.Type.MISS) {
            mop = this.pixelmon.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.pixelmon.func_226277_ct_(), this.pixelmon.func_174813_aQ().field_72337_e, this.pixelmon.func_226281_cx_()), new Vector3d(this.pixelmon.func_226277_ct_() + this.pixelmon.func_70040_Z().field_72450_a * 5.0, this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.func_226281_cx_() + this.pixelmon.func_70040_Z().field_72449_c * 5.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.pixelmon));
        }
        if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
            useLastChangeDirection = true;
            this.lastChangeDirection = true;
        }
        --this.ticksToRefresh;
        if (this.moveSpeed == 0.0f || useLastChangeDirection || this.pixelmon.func_213322_ci().func_82615_a() * this.pixelmon.func_213322_ci().func_82615_a() + this.pixelmon.func_213322_ci().func_82616_c() * this.pixelmon.func_213322_ci().func_82616_c() < (double)(this.moveSpeed / 4.0f)) {
            this.pickDirection(useLastChangeDirection);
            this.pickSpeed();
            this.pixelmon.func_213352_e(new Vector3d(0.0, 0.0, (double)this.moveSpeed));
        }
    }

    public boolean func_75253_b() {
        if (!this.pixelmon.func_70090_H()) {
            return false;
        }
        this.moveSpeed *= this.decayRate;
        this.pixelmon.func_213293_j(this.pixelmon.func_213322_ci().func_82615_a() * (double)this.decayRate, this.pixelmon.func_213322_ci().func_82617_b() * (double)this.decayRate, this.pixelmon.func_213322_ci().func_82616_c() * (double)this.decayRate);
        this.pixelmon.field_70761_aq = this.pixelmon.field_70177_z;
        return true;
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = this.pixelmon.func_70681_au().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
        } else {
            rotAmt = this.pixelmon.func_70681_au().nextInt(10) - 5;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        this.pixelmon.field_70177_z = (float)((double)this.pixelmon.field_70177_z + rotAmt);
    }

    public void pickSpeed() {
        if (this.ticksToRefresh < 0) {
            this.pixelmon.setSwimDepth(-1);
            this.ticksToRefresh = this.pixelmon.field_70170_p.func_234923_W_() == DrownedWorld.WORLD ? 600 : (this.pixelmon.getSwimmingParameters() == null ? 160 : this.pixelmon.getSwimmingParameters().getRefreshRate());
        }
        this.moveSpeed = 2.8f * (this.pixelmon.func_70681_au().nextFloat() * this.swimSpeed + this.swimSpeed / 2.0f);
        double refreshRate = 160.0;
        if (this.pixelmon.field_70170_p.func_234923_W_() == DrownedWorld.WORLD) {
            refreshRate = 600.0;
        } else if (this.pixelmon.getSwimmingParameters() != null) {
            refreshRate = this.pixelmon.getSwimmingParameters().getRefreshRate();
        }
        if (refreshRate == 0.0) {
            refreshRate = 1.0;
        }
        double v = this.pixelmon.getSwimDepth();
        int wdepth = WorldHelper.getWaterDepth(this.pixelmon.func_233580_cy_(), this.pixelmon.field_70170_p);
        this.pixelmon.func_213317_d(new Vector3d(this.pixelmon.func_213322_ci().func_82615_a(), ((double)wdepth - v) / refreshRate, this.pixelmon.func_213322_ci().func_82616_c()));
    }
}

