/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GrowthRequirement
extends AbstractPokemonRequirement<EnumGrowth> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"growth", "gr"});
    private EnumGrowth growth;

    public GrowthRequirement() {
        super(KEYS);
    }

    public GrowthRequirement(EnumGrowth growth) {
        this();
        this.growth = growth;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return Collections.singletonList(this.createInstance(EnumGrowth.Ordinary));
        }
        EnumGrowth growth = this.parseGrowth(args[1]);
        if (growth == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createInstance(growth));
    }

    private EnumGrowth parseGrowth(String s) {
        EnumGrowth growth = EnumGrowth.getGrowthFromString(s);
        if (growth == null) {
            try {
                growth = EnumGrowth.getGrowthFromIndex(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return growth;
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, EnumGrowth> createInstance(EnumGrowth value) {
        return new GrowthRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (pixelmon.getGrowth() == null) {
            return this.growth == null;
        }
        return Objects.equals(pixelmon.getGrowth(), this.growth);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setGrowth(this.growth);
    }

    @Override
    public EnumGrowth getValue() {
        return this.growth;
    }
}

