/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.Collection;
import java.util.function.Supplier;
import mezz.jei.config.SearchMode;
import mezz.jei.search.ISearchStorage;

public class PrefixInfo<T> {
    private final char prefix;
    private final IModeGetter modeGetter;
    private final IStringsGetter<T> stringsGetter;
    private final Supplier<ISearchStorage<T>> storageSupplier;

    public PrefixInfo(char prefix, IModeGetter modeGetter, IStringsGetter<T> stringsGetter, Supplier<ISearchStorage<T>> storageSupplier) {
        this.prefix = prefix;
        this.modeGetter = modeGetter;
        this.stringsGetter = stringsGetter;
        this.storageSupplier = storageSupplier;
    }

    public char getPrefix() {
        return this.prefix;
    }

    public SearchMode getMode() {
        return this.modeGetter.getMode();
    }

    public ISearchStorage<T> createStorage() {
        return this.storageSupplier.get();
    }

    public Collection<String> getStrings(T element) {
        return this.stringsGetter.getStrings(element);
    }

    public String toString() {
        return "PrefixInfo{" + this.prefix + '}';
    }

    @FunctionalInterface
    public static interface IModeGetter {
        public SearchMode getMode();
    }

    @FunctionalInterface
    public static interface IStringsGetter<T> {
        public Collection<String> getStrings(T var1);
    }
}

