/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.collect.SetMultiMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;

public class BrewingRecipeUtil {
    public static final ItemStack POTION = new ItemStack((IItemProvider)Items.field_151068_bn);
    public static final ItemStack WATER_BOTTLE = PotionUtils.func_185188_a((ItemStack)POTION.func_77946_l(), (Potion)Potions.field_185230_b);
    private final Map<String, Integer> brewingStepCache = new HashMap<String, Integer>();
    private final SetMultiMap<String, String> potionMap = new SetMultiMap();
    private final IIngredientHelper<ItemStack> itemStackHelper;

    public BrewingRecipeUtil(IIngredientHelper<ItemStack> itemStackHelper) {
        this.itemStackHelper = itemStackHelper;
        this.clearCache();
    }

    public void addRecipe(List<ItemStack> inputPotions, ItemStack outputPotion) {
        String potionOutputUid = this.itemStackHelper.getUniqueId(outputPotion, UidContext.Recipe);
        for (ItemStack inputPotion : inputPotions) {
            String potionInputUid = this.itemStackHelper.getUniqueId(inputPotion, UidContext.Recipe);
            this.potionMap.put(potionOutputUid, potionInputUid);
        }
        this.clearCache();
    }

    public int getBrewingSteps(ItemStack outputPotion) {
        String potionInputUid = this.itemStackHelper.getUniqueId(outputPotion, UidContext.Recipe);
        return this.getBrewingSteps(potionInputUid, new HashSet<String>());
    }

    private void clearCache() {
        if (this.brewingStepCache.size() != 1) {
            this.brewingStepCache.clear();
            String waterBottleUid = this.itemStackHelper.getUniqueId(WATER_BOTTLE, UidContext.Recipe);
            this.brewingStepCache.put(waterBottleUid, 0);
        }
    }

    private int getBrewingSteps(String potionOutputUid, Set<String> previousSteps) {
        Integer brewingSteps = this.brewingStepCache.get(potionOutputUid);
        if (brewingSteps == null) {
            previousSteps.add(potionOutputUid);
            Object prevPotions = this.potionMap.get(potionOutputUid);
            if (!prevPotions.isEmpty()) {
                int minPrevSteps = Integer.MAX_VALUE;
                for (String prevPotion : prevPotions) {
                    if (previousSteps.contains(prevPotion)) continue;
                    int prevSteps = this.getBrewingSteps(prevPotion, previousSteps);
                    minPrevSteps = Math.min(minPrevSteps, prevSteps);
                }
                if (minPrevSteps < Integer.MAX_VALUE) {
                    brewingSteps = minPrevSteps + 1;
                    this.brewingStepCache.put(potionOutputUid, brewingSteps);
                }
            }
        }
        if (brewingSteps == null) {
            return Integer.MAX_VALUE;
        }
        return brewingSteps;
    }
}

