/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixins;

import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrashReport.class}, priority=500)
public abstract class MixinCrashReport {
    @Shadow
    @Final
    private CrashReportCategory field_85061_c;

    private CrashReport getThis() {
        return (CrashReport)this;
    }

    @Inject(method={"fillSystemDetails"}, at={@At(value="TAIL")})
    private void afterFillSystemDetails(CallbackInfo ci) {
        this.field_85061_c.func_189529_a("Suspected Mods", () -> {
            try {
                Set<CommonModMetadata> suspectedMods = ModIdentifier.getSuspectedModsOf(this.getThis());
                if (!suspectedMods.isEmpty()) {
                    return suspectedMods.stream().map(mod -> mod.name() + " (" + mod.id() + ")").collect(Collectors.joining(", "));
                }
                return "None";
            }
            catch (Throwable e) {
                return ExceptionUtils.getStackTrace((Throwable)e).replace("\t", "    ");
            }
        });
    }
}

