/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.forge.platform;

import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.platform.ModsByLocation;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;

public class ForgePlatform
implements NecPlatform {
    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public ModsByLocation getModsAtLocationsInDisk() {
        HashMap<Path, Set<CommonModMetadata>> modMap = new HashMap<Path, Set<CommonModMetadata>>();
        ModList mods = ModList.get();
        if (mods == null) {
            return new ModsByLocation(modMap);
        }
        for (ModFileInfo modFile : mods.getModFiles()) {
            Path modJar = modFile.getFile().getFilePath();
            for (IModInfo modInfo : modFile.getMods()) {
                modMap.computeIfAbsent(modJar, f -> new HashSet()).add(ForgePlatform.toCommon(modInfo));
            }
        }
        return new ModsByLocation(modMap);
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    @Nullable
    public InputStream getResource(Path relativePath) {
        return NecPlatform.class.getResourceAsStream("/" + relativePath.toString());
    }

    @Override
    public List<CommonModMetadata> getModMetadatas(String modId) {
        ModFileInfo file = ModList.get().getModFileById(modId);
        if (file == null) {
            return Collections.emptyList();
        }
        return file.getMods().stream().map(ForgePlatform::toCommon).collect(Collectors.toList());
    }

    private static CommonModMetadata toCommon(IModInfo imod) {
        Optional issueUrl = ((ModFileInfo)imod.getOwningFile()).getConfigElement(new String[]{"issueTrackerURL"});
        Object authorsObj = ((ModInfo)imod).getConfigElement(new String[]{"authors"}).orElse(null);
        List<String> authors = authorsObj instanceof String ? Collections.singletonList(authorsObj) : (List<String>)authorsObj;
        return new CommonModMetadata(imod.getModId(), imod.getDisplayName(), issueUrl.orElse(null), authors, ((ModFileInfo)imod.getOwningFile()).getFile().getFilePath());
    }
}

