/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.item;

import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.client.gui.CardScreen;
import com.pixelmonmod.tcg.network.packets.CardSyncPacket;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CardItem
extends Item {
    private static final String name = "card";

    public CardItem() {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_TCG_CARDS).func_200917_a(1));
    }

    public ITextComponent func_200295_i(ItemStack itemstack) {
        ImmutableCard c;
        if (itemstack.func_77978_p() != null && (c = Cards.fromNBT(itemstack.func_77978_p())) != null) {
            return new TranslationTextComponent(c.getName());
        }
        return super.func_200295_i(itemstack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack.func_77978_p() != null) {
            ImmutableCard c = Cards.fromNBT(stack.func_77978_p());
            CardSet cardSet = CardSets.get(c.getSetID());
            if (c != null && stack.func_179543_a("Lore") == null && cardSet != null) {
                tooltip.clear();
                tooltip.add(c.getTranslatedName());
                tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"item.card.lore.code", (Object[])new Object[]{c.getCode()})));
                tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"item.card.lore.set", (Object[])new Object[]{cardSet.getName()})));
                tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"item.card.lore.rarity", (Object[])new Object[]{c.getRarity().getLocalizedName()})));
                tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"item.card.lore.type", (Object[])new Object[]{c.getCardType().getLocalizedName()})));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K) {
            this.openScreen(player, hand);
        }
        return super.func_77659_a(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(PlayerEntity player, Hand hand) {
        if (player.func_184586_b(hand).func_77978_p() != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new CardScreen(Cards.fromNBT(player.func_184586_b(hand).func_77978_p())));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        CompoundNBT tag;
        ImmutableCard card;
        if (stack.func_77978_p() != null && (card = Cards.fromCode((tag = stack.func_77978_p()).func_74779_i(ImmutableCard.CARD_CODE_NBT_KEY))) != null) {
            if (card.getCardType() == CardType.ENERGY && !card.isSpecial()) {
                return 64;
            }
            if (card.getCardType() != CardType.ASPEC) {
                return 4;
            }
        }
        return 1;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn != null && !worldIn.field_72995_K && entityIn instanceof ServerPlayerEntity) {
            ImmutableCard c;
            CompoundNBT tag;
            ServerPlayerEntity p = (ServerPlayerEntity)entityIn;
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new CompoundNBT());
            }
            if (!(tag = stack.func_77978_p()).func_74764_b(ImmutableCard.CARD_CODE_NBT_KEY) && (c = Cards.getRandomCard()) != null) {
                tag.func_74778_a(ImmutableCard.CARD_CODE_NBT_KEY, c.getCode());
                NetworkHelper.sendPacket(new CardSyncPacket(itemSlot, c.getCode(), false), p);
            }
        }
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (ImmutableCard c : Cards.getAll()) {
                items.add((Object)c.getItemStack(1));
            }
        }
    }

    public static String getName() {
        return name;
    }
}

