/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;

public class RainDance
extends BasePowerEffect {
    public RainDance() {
        super("RainDance");
    }

    @Override
    public boolean isEnabled(PokemonCardState pokemon, GameClientState client) {
        return super.isEnabled(pokemon, client) && client.getMe().getHand().stream().anyMatch(c -> c.getCardType() == CardType.ENERGY && c.getMainEnergy() == Energy.WATER);
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        return SelectorHelper.generateSelectorForActiveAndBench(server.getPlayer(server.getCurrentTurn()), "power.raindance.selector.chooseattach");
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState client) {
        return !pokemon.getParameters().isEmpty();
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        PokemonCardState attachTo = (PokemonCardState)pokemon.getParameters().get(0);
        ImmutableCard water = player.getHand().stream().filter(c -> c.getCardType() == CardType.ENERGY && c.getMainEnergy() == Energy.WATER).findFirst().get();
        player.getHand().remove(water);
        attachTo.getAttachments().add(new CommonCardState(water));
    }
}

